/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.runtime;

import com.restlet.client.async.Promise;
import com.restlet.client.platform.CryptoApi;
import com.restlet.client.script.method.Base64Method;
import com.restlet.client.script.method.ConcatMethod;
import com.restlet.client.script.method.HMACMethod;
import com.restlet.client.script.method.HashMethod;
import com.restlet.client.script.method.JsonPathMethod;
import com.restlet.client.script.method.LengthMethod;
import com.restlet.client.script.method.LowerMethod;
import com.restlet.client.script.method.MD5Method;
import com.restlet.client.script.method.RandomNumberMethod;
import com.restlet.client.script.method.StringMethod;
import com.restlet.client.script.method.SubStringMethod;
import com.restlet.client.script.method.TimestampMethod;
import com.restlet.client.script.method.UUIDGeneratorMethod;
import com.restlet.client.script.method.UpperMethod;
import com.restlet.client.script.runtime.ScriptMethodParameter;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.utils.EnumUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface ScriptMethod {
    public String getName();

    public Promise<ScriptValue> execute(ScriptValue var1, List<ScriptValue> var2);

    public static enum Type {
        base64(Base64Method.class, new ArrayList<ScriptMethodParameter>(), false),
        hmac(HMACMethod.class, Arrays.asList(new ScriptMethodParameter("Cipher", EnumUtils.getEnumNames((Enum[])CryptoApi.HashType.values())), new ScriptMethodParameter("Secret", ScriptMethodParameter.Type.String), new ScriptMethodParameter("Output", EnumUtils.getEnumNames((Enum[])CryptoApi.Output.values()), CryptoApi.Output.Base64.name())), false),
        sha(HashMethod.class, Arrays.asList(new ScriptMethodParameter("Cipher", EnumUtils.getEnumNames((Enum[])CryptoApi.HashType.values())), new ScriptMethodParameter("Output", EnumUtils.getEnumNames((Enum[])CryptoApi.Output.values()), CryptoApi.Output.Base64.name())), false),
        md5(MD5Method.class, new ArrayList<ScriptMethodParameter>(), false),
        upper(UpperMethod.class, new ArrayList<ScriptMethodParameter>(), false),
        lower(LowerMethod.class, new ArrayList<ScriptMethodParameter>(), false),
        string(StringMethod.class, Collections.singletonList(new ScriptMethodParameter("Quotes", Arrays.asList("'", "\""), "\"")), false),
        substring(SubStringMethod.class, Arrays.asList(new ScriptMethodParameter("Start", ScriptMethodParameter.Type.Integer, "0"), new ScriptMethodParameter("End", ScriptMethodParameter.Type.Integer)), false),
        concat(ConcatMethod.class, Collections.singletonList(new ScriptMethodParameter("Content", ScriptMethodParameter.Type.String)), false),
        length(LengthMethod.class, new ArrayList<ScriptMethodParameter>(), false),
        timestamp(TimestampMethod.class, new ArrayList<ScriptMethodParameter>(), true),
        uuid(UUIDGeneratorMethod.class, new ArrayList<ScriptMethodParameter>(), true),
        random(RandomNumberMethod.class, Collections.singletonList(new ScriptMethodParameter("Maximum", ScriptMethodParameter.Type.Integer)), true),
        jsonPath(JsonPathMethod.class, Collections.singletonList(new ScriptMethodParameter("JSON path", ScriptMethodParameter.Type.String, "$")), false);

        final boolean standalone;
        Class<? extends ScriptMethod> clazz;
        List<ScriptMethodParameter> parameters;

        private Type(Class<? extends ScriptMethod> clazz, List<ScriptMethodParameter> parameters, boolean standalone) {
            this.clazz = clazz;
            this.parameters = parameters;
            this.standalone = standalone;
        }

        public static Type getByName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            throw new RuntimeException("ScriptMethod type " + name + " does not exist.");
        }

        public List<ScriptMethodParameter> getParameters() {
            return this.parameters;
        }

        public boolean isStandalone() {
            return this.standalone;
        }
    }
}

