/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.runtime.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.net.http.request.HttpMethodDefinition;
import com.restlet.client.net.request.RequestBodyTo;
import com.restlet.client.net.request.RequestHeaderTo;
import com.restlet.client.net.uri.UriTo;
import com.restlet.client.net.uri.UriUtils;
import com.restlet.client.platform.json.JsonArray;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonException;
import com.restlet.client.platform.json.JsonObject;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.script.ScriptEvaluator;
import com.restlet.client.utils.StringUtils;
import java.util.List;

public class RequestJSONReference {
    private final JsonObject root;
    private final JsonEngine jsonEngine;
    private final ScriptEvaluator scriptEvaluator;
    private final EnvironmentsDao environmentsDao;
    private final RepositoryDao repositoryDao;

    private RequestJSONReference(JsonEngine jsonEngine, ScriptEvaluator scriptEvaluator, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao) {
        this.root = jsonEngine.newJsonObject();
        this.jsonEngine = jsonEngine;
        this.scriptEvaluator = scriptEvaluator;
        this.environmentsDao = environmentsDao;
        this.repositoryDao = repositoryDao;
    }

    public void setMethod(HttpMethodDefinition method) {
        if (method != null) {
            this.root.put("method", this.jsonEngine.newJsonString(method.getName()));
        } else {
            this.root.put("method", null);
        }
    }

    public void setHeaders(List<RequestHeaderTo> headers) {
        if (headers != null) {
            JsonObject refHeaders = this.jsonEngine.newJsonObject();
            for (RequestHeaderTo reqHeader : headers) {
                if (reqHeader == null || !reqHeader.isEnabled() || StringUtils.isBlank(reqHeader.getName()) || reqHeader.getValue() == null) continue;
                JsonValue refHeader = refHeaders.get(reqHeader.getName().toLowerCase());
                if (refHeader == null) {
                    refHeaders.put(reqHeader.getName().toLowerCase(), this.jsonEngine.newJsonString(reqHeader.getValue()));
                    continue;
                }
                if (refHeader.isArray() != null) {
                    refHeader.isArray().set(refHeader.isArray().size(), this.jsonEngine.newJsonString(reqHeader.getValue()));
                    continue;
                }
                if (refHeader.isString() == null) continue;
                JsonArray refHeadersArray = this.jsonEngine.newJsonArray();
                refHeadersArray.set(0, refHeader);
                refHeadersArray.set(1, this.jsonEngine.newJsonString(reqHeader.getValue()));
                refHeaders.put(reqHeader.getName().toLowerCase(), refHeadersArray);
            }
            this.root.put("headers", refHeaders);
        } else {
            this.root.put("headers", null);
        }
    }

    public JsonValue asJSON() {
        return this.root;
    }

    public void setUri(UriTo uri) {
        if (uri == null) {
            this.root.put("uri", null);
            return;
        }
        this.root.put("uri", this.jsonEngine.newJsonString(UriUtils.printUri(uri, UriUtils.SchemePrintOption.PRINT_SCHEME)));
    }

    public Promise<Void> setBody(final RequestBodyTo body) {
        if (body != null && body.getBodyType() != null) {
            switch (body.getBodyType()) {
                case File: 
                case Form: {
                    break;
                }
                case Text: {
                    if (StringUtils.isBlank(body.getTextBody())) break;
                    return this.scriptEvaluator.evaluate(body.getTextBody(), this.environmentsDao, this.repositoryDao).doOnResolve(new Consumer<String>(){

                        @Override
                        public void consume(String parsedValue) {
                            JsonValue json = null;
                            try {
                                json = RequestJSONReference.this.jsonEngine.fromJson(parsedValue);
                            }
                            catch (JsonException jsonException) {
                                // empty catch block
                            }
                            if (json != null) {
                                RequestJSONReference.this.root.put("body", json);
                                return;
                            }
                            RequestJSONReference.this.root.put("body", RequestJSONReference.this.jsonEngine.newJsonString(body.getTextBody()));
                        }
                    }).castToVoidPromise();
                }
            }
        }
        return Promises.of();
    }

    public static Promise<RequestJSONReference> create(JsonEngine jsonEngine, ScriptEvaluator scriptEvaluator, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao, HttpMethodDefinition method, List<RequestHeaderTo> headers, UriTo uri, RequestBodyTo body) {
        final RequestJSONReference requestJSONReference = new RequestJSONReference(jsonEngine, scriptEvaluator, environmentsDao, repositoryDao);
        requestJSONReference.setMethod(method);
        requestJSONReference.setHeaders(headers);
        requestJSONReference.setUri(uri);
        return requestJSONReference.setBody(body).map(new Function<Void, RequestJSONReference>(){

            @Override
            public RequestJSONReference apply(Void whatever) {
                return requestJSONReference;
            }
        });
    }
}

