/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.scanner.impl;

import com.restlet.client.script.scanner.ScriptScanner;
import com.restlet.client.script.scanner.lex.ScriptLexType;
import com.restlet.client.script.scanner.lex.ScriptLexeme;
import com.restlet.client.script.scanner.lex.SimpleLexeme;
import com.restlet.client.script.scanner.lex.StringLexeme;
import com.restlet.client.utils.StringUtils;

public class ScriptScannerImpl
implements ScriptScanner {
    final String script;
    final char[] chars;
    int index;

    public ScriptScannerImpl(String script) {
        this.script = script;
        this.index = 0;
        this.chars = script != null ? script.toCharArray() : null;
    }

    static final boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    static final boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static final boolean isAlphaNum(char ch) {
        return ScriptScannerImpl.isAlpha(ch) || ScriptScannerImpl.isNumber(ch);
    }

    static final boolean isWS(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    @Override
    public ScriptLexeme scan() {
        if (this.isEOF()) {
            return null;
        }
        State state = State.Initial;
        StringBuilder value = new StringBuilder();
        block12: for (int i = this.index; i < this.chars.length; ++i) {
            char ch = this.chars[i];
            switch (state) {
                case Initial: {
                    if (ScriptScannerImpl.isAlpha(ch) || ch == '_') {
                        if (value.length() > 0) {
                            value.append(ch);
                            continue block12;
                        }
                        value.append(ch);
                        state = State.Identifier;
                        continue block12;
                    }
                    if (ScriptScannerImpl.isNumber(ch)) {
                        if (value.length() > 0) {
                            value.append(ch);
                            continue block12;
                        }
                        value.append(ch);
                        state = State.Number;
                        continue block12;
                    }
                    if (ch == '\"') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        state = State.QuotedString;
                        continue block12;
                    }
                    if (ch == '\'') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        state = State.QuotedString;
                        continue block12;
                    }
                    if (ch == '.') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.Dot, value, this.index);
                    }
                    if (ch == ',') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.Comma, value, this.index);
                    }
                    if (ch == '{') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ExpressionBegin, value, this.index);
                    }
                    if (ch == '}') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ExpressionEnd, value, this.index);
                    }
                    if (ch == '(') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ParenthesesLeft, value, this.index);
                    }
                    if (ch == ')') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ParenthesesRight, value, this.index);
                    }
                    if (ch == '$') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        state = State.DollarExpression;
                        continue block12;
                    }
                    if (ch == '[') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.BracketLeft, value, this.index);
                    }
                    if (ch == ']') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.BracketRight, value, this.index);
                    }
                    if (ScriptScannerImpl.isWS(ch)) {
                        if (!StringUtils.isBlank(value.toString())) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        if (i + 1 < this.chars.length && ScriptScannerImpl.isWS(this.chars[i + 1])) continue block12;
                        return this.createLexeme(ScriptLexType.Text, value, this.index);
                    }
                    value.append(ch);
                    continue block12;
                }
                case Identifier: {
                    if (ScriptScannerImpl.isAlphaNum(ch) || ch == '_') {
                        value.append(ch);
                        continue block12;
                    }
                    if (ScriptScannerImpl.isWS(ch) || ch == '.' || ch == '}' || ch == '{' || ch == '(' || ch == ')' || ch == ']' || ch == '[' || ch == ',') {
                        return this.createLexeme(ScriptLexType.Id, value, this.index);
                    }
                    value.append(ch);
                    state = State.Initial;
                    continue block12;
                }
                case Number: {
                    if (ScriptScannerImpl.isNumber(ch)) {
                        value.append(ch);
                        continue block12;
                    }
                    if (ScriptScannerImpl.isWS(ch) || ch == '.' || ch == '}' || ch == '{' || ch == '(' || ch == ')' || ch == ']' || ch == '[' || ch == ',') {
                        return this.createLexeme(ScriptLexType.Number, value, this.index);
                    }
                    value.append(ch);
                    state = State.Initial;
                    continue block12;
                }
                case QuotedString: {
                    if (value.charAt(0) == ch) {
                        value.append(ch);
                        return this.createStringLexeme(value, this.index);
                    }
                    if (ch == '\\') {
                        state = State.EscapedQuote;
                        continue block12;
                    }
                    value.append(ch);
                    continue block12;
                }
                case DollarExpression: {
                    if (ch == '{') {
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ExpressionBegin, value, this.index);
                    }
                    value.append(ch);
                    state = State.Initial;
                    continue block12;
                }
                case EscapedQuote: {
                    if (ch == '\\') {
                        value.append('\\');
                        continue block12;
                    }
                    if (value.charAt(0) != ch) {
                        value.append('\\');
                    }
                    value.append(ch);
                    state = State.QuotedString;
                }
            }
        }
        switch (state) {
            case Identifier: {
                return this.createLexeme(ScriptLexType.Id, value, this.index);
            }
            case Number: {
                return this.createLexeme(ScriptLexType.Number, value, this.index);
            }
        }
        return this.createLexeme(ScriptLexType.Text, value, this.index);
    }

    @Override
    public ScriptLexeme findExpressionBegin() {
        if (this.isEOF()) {
            return null;
        }
        State state = State.Initial;
        StringBuilder value = new StringBuilder();
        block4: for (int i = this.index; i < this.chars.length; ++i) {
            char ch = this.chars[i];
            switch (state) {
                case Initial: {
                    if (ch == '{') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ExpressionBegin, value, this.index);
                    }
                    if (ch == '$') {
                        state = State.DollarExpression;
                        continue block4;
                    }
                    value.append(ch);
                    continue block4;
                }
                case DollarExpression: {
                    if (ch == '{') {
                        if (value.length() > 0) {
                            return this.createLexeme(ScriptLexType.Text, value, this.index);
                        }
                        value.append('$');
                        value.append(ch);
                        return this.createLexeme(ScriptLexType.ExpressionBegin, value, this.index);
                    }
                    value.append(ch);
                    state = State.Initial;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    final ScriptLexeme createLexeme(ScriptLexType type, StringBuilder value, int index) {
        String stringValue = value.toString();
        SimpleLexeme lex = null;
        lex = ScriptLexType.Text.equals((Object)type) && StringUtils.isBlank(stringValue) ? new SimpleLexeme(ScriptLexType.WhiteSpace, index, stringValue) : new SimpleLexeme(type, index, stringValue);
        this.index += stringValue.length();
        return lex;
    }

    final ScriptLexeme createStringLexeme(StringBuilder value, int index) {
        String quotedString = value.toString();
        String stringValue = "";
        if (quotedString.length() > 2) {
            stringValue = quotedString.substring(1, quotedString.length() - 1);
        }
        StringLexeme lex = new StringLexeme(stringValue, index, Character.valueOf(quotedString.charAt(0)));
        int i = stringValue.indexOf(lex.getQuote().charValue());
        while (i != -1) {
            ++this.index;
            i = stringValue.indexOf(lex.getQuote().charValue(), i + 1);
        }
        this.index += quotedString.length();
        return lex;
    }

    @Override
    public final boolean isEOF() {
        return this.chars == null || this.chars.length == 0 || this.index >= this.chars.length;
    }

    @Override
    public ScriptLexeme close() {
        if (this.isEOF()) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        value.append(this.chars, this.index, this.chars.length - this.index);
        return this.createLexeme(ScriptLexType.Text, value, this.index);
    }

    @Override
    public String getSource(int start, int end) {
        if (start >= 0 && end > 0 && start < end && start < this.chars.length && end <= this.chars.length) {
            return String.copyValueOf(this.chars, start, end - start);
        }
        return null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getLength() {
        return this.chars != null ? this.chars.length : 0;
    }

    static enum State {
        DollarExpression,
        QuotedString,
        Identifier,
        EscapedQuote,
        Initial,
        Number;

    }
}

