/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.value;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;

public class ScriptJsonValue
implements ScriptValue {
    private final JsonEngine engine;
    private final JsonValue value;

    public ScriptJsonValue(JsonValue value, JsonEngine engine) {
        this.value = value;
        this.engine = engine;
    }

    public String toString() {
        if (this.value == null || this.value.isNull() != null) {
            return null;
        }
        if (this.value.isString() != null) {
            return this.value.isString().stringValue();
        }
        return this.value.toString();
    }

    @Override
    public Promise<ScriptValue> select(String path) {
        if (this.value == null) {
            return Promises.of();
        }
        if (this.value.isObject() != null) {
            JsonValue jsonValue = this.value.isObject().get(path);
            if (jsonValue != null) {
                return Promises.of(new ScriptJsonValue(jsonValue, this.engine));
            }
        } else if (this.value.isArray() != null) {
            try {
                JsonValue jsonValue;
                Integer index = Integer.valueOf(path);
                if (index != null && index >= 0 && index < this.value.isArray().size() && (jsonValue = this.value.isArray().get(index)) != null) {
                    return Promises.of(new ScriptJsonValue(jsonValue, this.engine));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.value.isString() != null) {
            return new ScriptStringValue(this.value.toString(), this.engine).select(path);
        }
        return Promises.of();
    }

    public JsonValue getJsonValue() {
        return this.value;
    }
}

