/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.value;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonException;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptJsonValue;
import com.restlet.client.utils.StringUtils;

public class ScriptStringValue
implements ScriptValue {
    private final String value;
    private final JsonEngine jsonParser;

    public ScriptStringValue(String value, JsonEngine jsonParser) {
        this.value = value;
        this.jsonParser = jsonParser;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Promise<ScriptValue> select(String path) {
        block8: {
            if (StringUtils.isBlank(this.value)) {
                return Promises.of();
            }
            try {
                JsonValue json = this.jsonParser.fromJson(this.value);
                if (json == null) break block8;
                if (json.isObject() != null) {
                    JsonValue jsonValue = json.isObject().get(path);
                    if (jsonValue != null) {
                        return Promises.of(new ScriptJsonValue(jsonValue, this.jsonParser));
                    }
                    break block8;
                }
                if (json.isArray() == null) break block8;
                try {
                    JsonValue jsonValue;
                    Integer index = Integer.valueOf(path);
                    if (index != null && index >= 0 && index < json.isArray().size() && (jsonValue = json.isArray().get(index)) != null) {
                        return Promises.of(new ScriptJsonValue(jsonValue, this.jsonParser));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (JsonException e) {
                e.printStackTrace();
            }
        }
        return Promises.of();
    }
}

