/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.tests.asserts.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.html.HtmlKit;
import com.restlet.client.net.http.HeaderUtils;
import com.restlet.client.net.http.HttpClientResultTo;
import com.restlet.client.net.http.HttpDate;
import com.restlet.client.net.http.response.HttpResponseTo;
import com.restlet.client.platform.blob.Blob;
import com.restlet.client.platform.blob.BlobReader;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.xml.XmlEngine;
import com.restlet.client.script.ScriptService;
import com.restlet.client.tests.asserts.AssertionEngine;
import com.restlet.client.tests.asserts.AssertionResultTo;
import com.restlet.client.tests.asserts.impl.JsonAssertionEngineImpl;
import com.restlet.client.tests.asserts.impl.XmlAssertionEngineImpl;
import com.restlet.client.utils.BlobUtils;
import com.restlet.client.utils.EntityUtils;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AssertionEngineImpl
implements AssertionEngine {
    private final HttpDate httpDate;
    private final BlobReader blobReader;
    private final HtmlKit htmlKit;
    private final ScriptService scriptService;
    private final XmlAssertionEngineImpl xmlAssertionEngine;
    private final JsonAssertionEngineImpl jsonAssertionEngine;
    private static final Blob emptyBlob = new Blob(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public boolean isInferredType() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public AssertionEngineImpl(JsonEngine jsonEngine, XmlEngine xmlEngine, HttpDate httpDate, BlobReader blobReader, HtmlKit htmlKit, ScriptService scriptService) {
        this.httpDate = httpDate;
        this.blobReader = blobReader;
        this.htmlKit = htmlKit;
        this.scriptService = scriptService;
        this.xmlAssertionEngine = new XmlAssertionEngineImpl(xmlEngine, httpDate, blobReader, htmlKit);
        this.jsonAssertionEngine = new JsonAssertionEngineImpl(jsonEngine, httpDate, blobReader, htmlKit);
    }

    @Override
    public Promise<Void> evaluateAndCheck(final AssertionResultTo assertion, final HttpClientResultTo result, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        assertion.setState(null);
        assertion.setEvaluatedPath(null);
        assertion.setEvaluatedValue(null);
        assertion.getMessages().clear();
        if (!EntityUtils.isEnabled(assertion) || assertion.getSubject() == null || assertion.getComparison() == null) {
            return Promises.of();
        }
        if (!StringUtils.isBlank(assertion.getPath())) {
            return this.scriptService.evaluate(assertion.getPath(), environmentsDao, repositoryDao).flatMap(new Function<String, Promise<Void>>(){

                @Override
                public Promise<Void> apply(String evaluatedPath) {
                    assertion.setEvaluatedPath(evaluatedPath);
                    return AssertionEngineImpl.this.evaluateAssertionValueAndCheck(assertion, result, environmentsDao, repositoryDao);
                }
            }).flatRecoverOnReject(new Function<Throwable, Promise<Void>>(){

                @Override
                public Promise<Void> apply(Throwable whatever) {
                    return AssertionEngineImpl.this.evaluateAssertionValueAndCheck(assertion, result, environmentsDao, repositoryDao);
                }
            });
        }
        return this.evaluateAssertionValueAndCheck(assertion, result, environmentsDao, repositoryDao);
    }

    private Promise<Void> evaluateAssertionValueAndCheck(final AssertionResultTo assertion, final HttpClientResultTo result, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao) {
        if (!StringUtils.isBlank(assertion.getValue())) {
            return this.scriptService.evaluate(assertion.getValue(), environmentsDao, repositoryDao).flatMap(new Function<String, Promise<Void>>(){

                @Override
                public Promise<Void> apply(String evaluatedValue) {
                    assertion.setEvaluatedValue(evaluatedValue);
                    return AssertionEngineImpl.this.checkEvaluatedAssertion(assertion, result);
                }
            }).flatRecoverOnReject(new Function<Throwable, Promise<Void>>(){

                @Override
                public Promise<Void> apply(Throwable whatever) {
                    return AssertionEngineImpl.this.checkEvaluatedAssertion(assertion, result);
                }
            });
        }
        return this.checkEvaluatedAssertion(assertion, result);
    }

    private Promise<Void> checkEvaluatedAssertion(AssertionResultTo assertion, HttpClientResultTo result) {
        if (assertion.getSubject() == null) {
            return Promises.of();
        }
        switch (assertion.getSubject()) {
            case Response: {
                return this.checkResponse(assertion, result);
            }
            case ResponseStatus: {
                if ("message".equals(assertion.getPath())) {
                    return this.checkStatusMessage(assertion, result != null ? result.getResponse() : null);
                }
                return this.checkStatusCode(assertion, result != null ? result.getResponse() : null);
            }
            case ResponseBody: {
                if ("length".equals(assertion.getPath())) {
                    return this.checkBodyLength(assertion, result != null ? result.getResponse() : null);
                }
                return this.checkBodyContent(assertion, result != null ? result.getResponse() : null);
            }
            case ResponseJsonBody: {
                return this.jsonAssertionEngine.checkBody(assertion, result != null ? result.getResponse() : null);
            }
            case ResponseXmlBody: {
                return this.xmlAssertionEngine.checkBody(assertion, result != null ? result.getResponse() : null);
            }
            case ResponseHeader: {
                return this.checkHeader(assertion, result != null ? result.getResponse() : null);
            }
        }
        return Promises.of();
    }

    @Override
    public Promise<Void> evaluateAndCheck(List<AssertionResultTo> assertions, HttpClientResultTo result, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao) {
        if (Objects.isNullOrEmpty(assertions)) {
            return Promises.of();
        }
        ArrayList promises = new ArrayList();
        for (AssertionResultTo assertion : assertions) {
            promises.add(this.evaluateAndCheck(assertion, result, environmentsDao, repositoryDao));
        }
        return Promises.all(promises).castToVoidPromise();
    }

    private Promise<Void> checkResponse(AssertionResultTo assertion, HttpClientResultTo response) {
        String stringValue;
        Integer expectedValue = null;
        String string = stringValue = !StringUtils.isBlank(assertion.getEvaluatedValue()) ? assertion.getEvaluatedValue() : assertion.getValue();
        if (!StringUtils.isBlank(stringValue)) {
            try {
                expectedValue = Integer.valueOf(stringValue.trim());
            }
            catch (Exception e) {
                assertion.setState(AssertionResultTo.State.Error);
                assertion.addErrorMessage("Value &lt;" + this.htmlKit.escape(stringValue.trim()) + "&gt; is not a number.");
                return Promises.of();
            }
        }
        if (expectedValue == null) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("Value &lt;&gt; is not a number.");
            return Promises.of();
        }
        if (response == null) {
            return Promises.of();
        }
        if (response.getRequestSent() != null && response.getResponseReceived() != null) {
            long latency = response.getResponseReceived().getTime() - response.getRequestSent().getTime();
            assertion.setActualValue(String.valueOf(latency));
            switch (assertion.getComparison()) {
                case Equals: {
                    if ((long)expectedValue.intValue() == latency) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected latency: &lt;" + expectedValue + "&gt; ms but was: &lt;" + latency + "&gt; ms.");
                    break;
                }
                case DoesNotEqual: {
                    if ((long)expectedValue.intValue() != latency) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected latency: &lt;" + expectedValue + "&gt; ms is the same.");
                    break;
                }
                case Less: {
                    if (latency < (long)expectedValue.intValue()) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Latency: &lt;" + latency + "&gt; ms is not less than: &lt;" + expectedValue + "&gt; ms.");
                    break;
                }
                case LessOrEqual: {
                    if (latency <= (long)expectedValue.intValue()) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Latency: &lt;" + latency + "&gt; ms is not less or equal to: &lt;" + expectedValue + "&gt; ms.");
                    break;
                }
                case Greater: {
                    if (latency > (long)expectedValue.intValue()) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Latency: &lt;" + latency + "&gt; ms is not greater than: &lt;" + expectedValue + "&gt; ms.");
                    break;
                }
                case GreateOrEqual: {
                    if (latency >= (long)expectedValue.intValue()) {
                        assertion.setState(AssertionResultTo.State.Ok);
                        break;
                    }
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Latency: &lt;" + latency + "&gt; ms is not greater or equal to: &lt;" + expectedValue + "&gt; ms.");
                    break;
                }
            }
        }
        return Promises.of();
    }

    private Promise<Void> checkStatusMessage(AssertionResultTo assertion, HttpResponseTo response) {
        if (response == null) {
            return Promises.of();
        }
        String expectedValue = !StringUtils.isBlank(assertion.getEvaluatedValue()) ? assertion.getEvaluatedValue() : assertion.getValue();
        String statusMessage = response.getStatus() != null ? response.getStatus().getMessage() : null;
        assertion.setActualValue(statusMessage);
        switch (assertion.getComparison()) {
            case Equals: {
                if (!StringUtils.isBlank(expectedValue) && !StringUtils.isBlank(statusMessage) && expectedValue.equalsIgnoreCase(statusMessage.trim()) || StringUtils.isBlank(expectedValue) && StringUtils.isBlank(statusMessage)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected response status message: &lt;" + (expectedValue != null ? this.htmlKit.escape(expectedValue) : "") + "&gt; but was: &lt;" + (statusMessage != null ? this.htmlKit.escape(statusMessage) : "") + "&gt;.");
                break;
            }
            case DoesNotEqual: {
                if (!StringUtils.isBlank(expectedValue) && !StringUtils.isBlank(statusMessage) && !expectedValue.equalsIgnoreCase(statusMessage.trim()) || StringUtils.isBlank(expectedValue) && !StringUtils.isBlank(statusMessage) || !StringUtils.isBlank(expectedValue) && StringUtils.isBlank(statusMessage)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status message: &lt;" + this.htmlKit.escape(expectedValue) + "&gt; is the same.");
                break;
            }
            case Exists: {
                if (!StringUtils.isBlank(statusMessage)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status message: &lt;" + (statusMessage != null ? this.htmlKit.escape(statusMessage) : "") + "&gt; is missing or is a blank expectedValue.");
                break;
            }
            case DoesNotExist: {
                if (StringUtils.isBlank(statusMessage)) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status message: &lt;" + this.htmlKit.escape(statusMessage) + "&gt; exits.");
                break;
            }
            case Contains: {
                if (!StringUtils.isBlank(statusMessage) && !StringUtils.isBlank(expectedValue) && statusMessage.toLowerCase().contains(expectedValue.toLowerCase())) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status message: &lt;" + (statusMessage != null ? this.htmlKit.escape(statusMessage) : "") + "&gt; does not contain: &lt;" + this.htmlKit.escape(expectedValue) + "&gt;.");
                break;
            }
            case DoesNotContain: {
                if (!(StringUtils.isBlank(statusMessage) || StringUtils.isBlank(expectedValue) || statusMessage.toLowerCase().contains(expectedValue.toLowerCase()))) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedValue) || StringUtils.isBlank(statusMessage)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status message: &lt;" + this.htmlKit.escape(statusMessage) + "&gt; contains: &lt;" + this.htmlKit.escape(expectedValue) + "&gt;.");
                break;
            }
        }
        return Promises.of();
    }

    private Promise<Void> checkStatusCode(AssertionResultTo assertion, HttpResponseTo response) {
        String expectedValueAsString;
        Integer expectedValue = null;
        String string = expectedValueAsString = !StringUtils.isBlank(assertion.getEvaluatedValue()) ? assertion.getEvaluatedValue() : assertion.getValue();
        if (!StringUtils.isBlank(expectedValueAsString)) {
            try {
                expectedValue = Integer.valueOf(expectedValueAsString.trim());
            }
            catch (Exception e) {
                assertion.setState(AssertionResultTo.State.Error);
                assertion.setActualValue(expectedValueAsString);
                assertion.addErrorMessage("Value &lt;" + this.htmlKit.escape(expectedValueAsString.trim()) + "&gt; is not a number.");
                return Promises.of();
            }
        }
        if (expectedValue == null) {
            return this.fillNotANumberInAssertion(assertion, expectedValueAsString);
        }
        if (response == null) {
            return Promises.of();
        }
        Integer statusCode = response.getStatus() != null ? response.getStatus().getCode() : null;
        assertion.setActualValue(String.valueOf(statusCode));
        switch (assertion.getComparison()) {
            case Equals: {
                if (statusCode == null) break;
                if (expectedValue.intValue() == statusCode.intValue()) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected response status code: &lt;" + expectedValue + "&gt; but was: &lt;" + statusCode + "&gt;.");
                break;
            }
            case DoesNotEqual: {
                if (statusCode == null) break;
                if (expectedValue.intValue() != statusCode.intValue()) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status code: &lt;" + expectedValue + "&gt; is the same.");
                break;
            }
            case Less: {
                if (statusCode == null) break;
                if (statusCode < expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status code: &lt;" + statusCode + "&gt; is not less than: &lt;" + expectedValue + "&gt;.");
                break;
            }
            case LessOrEqual: {
                if (statusCode == null) break;
                if (statusCode <= expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status code: &lt;" + statusCode + "&gt; is not less or equal to: &lt;" + expectedValue + "&gt;.");
                break;
            }
            case Greater: {
                if (statusCode == null) break;
                if (statusCode > expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status code: &lt;" + statusCode + "&gt; is not greater than: &lt;" + expectedValue + "&gt;.");
                break;
            }
            case GreateOrEqual: {
                if (statusCode == null) break;
                if (statusCode >= expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response status code: &lt;" + statusCode + "&gt; is not greater or equal to: &lt;" + expectedValue + "&gt;.");
                break;
            }
        }
        return Promises.of();
    }

    private Promise<Void> fillNotANumberInAssertion(AssertionResultTo assertion, String expectedValueAsString) {
        assertion.setState(AssertionResultTo.State.Error);
        assertion.setActualValue(expectedValueAsString);
        assertion.addErrorMessage("Value &lt;&gt; is not a number.");
        return Promises.of();
    }

    private Promise<Void> checkBodyLength(AssertionResultTo assertion, HttpResponseTo response) {
        String expectedValueAsString;
        Integer expectedValue = null;
        String string = expectedValueAsString = !StringUtils.isBlank(assertion.getEvaluatedValue()) ? assertion.getEvaluatedValue() : assertion.getValue();
        if (!StringUtils.isBlank(expectedValueAsString)) {
            try {
                expectedValue = Integer.valueOf(expectedValueAsString.trim());
            }
            catch (Exception e) {
                assertion.setState(AssertionResultTo.State.Error);
                assertion.setActualValue(expectedValueAsString);
                assertion.addErrorMessage("Value &lt;" + this.htmlKit.escape(expectedValueAsString.trim()) + "&gt; is not a number.");
                return Promises.of();
            }
        }
        if (expectedValue == null) {
            return this.fillNotANumberInAssertion(assertion, expectedValueAsString);
        }
        if (response == null) {
            return Promises.of();
        }
        int value = expectedValue;
        Blob responseBlob = response.getBody() == null || response.getBody().getBlob() == null ? emptyBlob : response.getBody().getBlob();
        return this.checkBodyLength(assertion, value, responseBlob.size()).recoverOnReject();
    }

    private Promise<Void> checkBodyLength(AssertionResultTo assertion, int expectedValue, int actualValue) {
        assertion.setActualValue(String.valueOf(actualValue));
        switch (assertion.getComparison()) {
            case Equals: {
                if (actualValue == expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected response body length: &lt;" + expectedValue + "&gt; bytes but was: &lt;" + actualValue + "&gt; bytes.");
                break;
            }
            case DoesNotEqual: {
                if (actualValue != expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body length: &lt;" + expectedValue + "&gt; bytes is the same.");
                break;
            }
            case Less: {
                if (actualValue < expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body length: &lt;" + actualValue + "&gt; bytes is not less than: &lt;" + expectedValue + "&gt; bytes.");
                break;
            }
            case LessOrEqual: {
                if (actualValue <= expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body length: &lt;" + actualValue + "&gt; bytes is not less or equal to: &lt;" + expectedValue + "&gt; bytes.");
                break;
            }
            case Greater: {
                if (actualValue > expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body length: &lt;" + actualValue + "&gt; bytes is not greater than: &lt;" + expectedValue + "&gt; bytes.");
                break;
            }
            case GreateOrEqual: {
                if (actualValue >= expectedValue) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body length: &lt;" + actualValue + "&gt; bytes is not greater or equal to: &lt;" + expectedValue + "&gt; bytes.");
                break;
            }
        }
        return Promises.of();
    }

    private Promise<Void> checkBodyContent(AssertionResultTo assertion, HttpResponseTo response) {
        if (response == null) {
            return Promises.of();
        }
        String value = this.getNonBlankValue(assertion);
        Blob responseBlob = response.getBody() == null || response.getBody().getBlob() == null ? emptyBlob : response.getBody().getBlob();
        return this.checkBodyContent(assertion, value, responseBlob).recoverOnReject();
    }

    private String getNonBlankValue(AssertionResultTo assertion) {
        if (!StringUtils.isBlank(assertion.getEvaluatedValue())) {
            return assertion.getEvaluatedValue().trim();
        }
        return !StringUtils.isBlank(assertion.getValue()) ? assertion.getValue().trim() : null;
    }

    private Promise<Void> checkBodyContent(final AssertionResultTo assertion, final String expectedValue, Blob actualContentBlob) {
        if (assertion == null) {
            return Promises.of();
        }
        return BlobUtils.read(this.blobReader, actualContentBlob).doOnReject(new Consumer<Throwable>(){

            @Override
            public void consume(Throwable throwable) {
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Cannot read response body.");
            }
        }).doOnResolve(new Consumer<String>(){

            @Override
            public void consume(String actualContent) {
                AssertionEngineImpl.this.checkBodyContent(assertion, expectedValue, actualContent);
            }
        }).castToVoidPromise();
    }

    private void checkBodyContent(AssertionResultTo assertion, String expectedValue, String actualContent) {
        assertion.setActualValue(actualContent);
        assertion.setState(AssertionResultTo.State.Ok);
        switch (assertion.getComparison()) {
            case Equals: {
                if (StringUtils.isBlank(actualContent)) {
                    if (StringUtils.isBlank(expectedValue)) break;
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected response body &lt;" + this.htmlKit.escape(expectedValue) + "&gt; but was empty.");
                    break;
                }
                if (StringUtils.isBlank(expectedValue)) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Expected empty body but body length was: &lt;" + actualContent.length() + "&gt; bytes.");
                    break;
                }
                if (this.compare(actualContent, expectedValue.trim()) == 0) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected response body &lt;" + this.htmlKit.escape(expectedValue.trim()) + "&gt; does not match.");
                break;
            }
            case DoesNotEqual: {
                if (StringUtils.isBlank(expectedValue) && StringUtils.isBlank(actualContent)) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response body is the same.");
                    break;
                }
                if (StringUtils.isBlank(actualContent) || StringUtils.isBlank(expectedValue) || this.compare(actualContent, expectedValue.trim()) != 0) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected response body &lt;" + this.htmlKit.escape(expectedValue.trim()) + "&gt; does not match.");
                break;
            }
            case Exists: {
                if (!StringUtils.isBlank(actualContent)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body does not exist.");
                break;
            }
            case DoesNotExist: {
                if (StringUtils.isBlank(actualContent)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body exists.");
                break;
            }
            case Contains: {
                if (StringUtils.isBlank(expectedValue) || (StringUtils.isBlank(actualContent) || actualContent.contains(expectedValue.trim())) && !StringUtils.isBlank(actualContent)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body does not contain &lt;" + this.htmlKit.escape(expectedValue.trim()) + "&gt;.");
                break;
            }
            case DoesNotContain: {
                if (StringUtils.isBlank(expectedValue) || StringUtils.isBlank(actualContent) || !actualContent.contains(expectedValue.trim())) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response body contains &lt;" + this.htmlKit.escape(expectedValue.trim()) + "&gt;.");
                break;
            }
        }
    }

    private Promise<Void> checkHeader(AssertionResultTo assertion, HttpResponseTo response) {
        if (response == null) {
            return Promises.of();
        }
        String headerName = StringUtils.firstNotBlank(assertion.getEvaluatedPath(), assertion.getPath()).orElse(null);
        if (StringUtils.isBlank(headerName)) {
            assertion.setState(AssertionResultTo.State.Error);
            assertion.addErrorMessage("Response header name is required.");
            return Promises.of();
        }
        String expectedHeaderValue = !StringUtils.isBlank(assertion.getEvaluatedValue()) ? assertion.getEvaluatedValue() : assertion.getValue();
        List<String> headerValues = HeaderUtils.findHeaderValue(response.getHeaders(), headerName);
        String headerValue = Objects.isNullOrEmpty(headerValues) ? null : StringUtils.joiner(headerValues).joinWith(",");
        assertion.setActualValue(headerValue);
        switch (assertion.getComparison()) {
            case Equals: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(expectedHeaderValue) && !StringUtils.isBlank(headerValue) && this.compare(expectedHeaderValue, headerValue) == 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Expected header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + (expectedHeaderValue != null ? this.htmlKit.escape(expectedHeaderValue) : "") + "&gt; but was: &lt;" + this.htmlKit.escape(headerValue) + "&gt;.");
                break;
            }
            case DoesNotEqual: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(expectedHeaderValue) && !StringUtils.isBlank(headerValue) && this.compare(expectedHeaderValue, headerValue) == 0) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; is the same.");
                    break;
                }
                assertion.setState(AssertionResultTo.State.Ok);
                break;
            }
            case Exists: {
                if (headerValue != null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                break;
            }
            case DoesNotExist: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; exists.");
                break;
            }
            case Contains: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(headerValue) && !StringUtils.isBlank(expectedHeaderValue) && headerValue.toLowerCase().contains(expectedHeaderValue.toLowerCase())) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; does not contain: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
            case DoesNotContain: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!(StringUtils.isBlank(headerValue) || StringUtils.isBlank(expectedHeaderValue) || headerValue.toLowerCase().contains(expectedHeaderValue.toLowerCase()))) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; contains: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
            case Less: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(headerValue) && !StringUtils.isBlank(expectedHeaderValue) && this.compare(headerValue, expectedHeaderValue) < 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; is not less than: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
            case LessOrEqual: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(headerValue) && !StringUtils.isBlank(expectedHeaderValue) && this.compare(headerValue, expectedHeaderValue) <= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; is not less or equal to: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
            case Greater: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(headerValue) && !StringUtils.isBlank(expectedHeaderValue) && this.compare(headerValue, expectedHeaderValue) > 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; is not greater than: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
            case GreateOrEqual: {
                if (headerValue == null) {
                    assertion.setState(AssertionResultTo.State.Failure);
                    assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; does not exist.");
                    break;
                }
                if (!StringUtils.isBlank(headerValue) && !StringUtils.isBlank(expectedHeaderValue) && this.compare(headerValue, expectedHeaderValue) >= 0) {
                    assertion.setState(AssertionResultTo.State.Ok);
                    break;
                }
                if (StringUtils.isBlank(expectedHeaderValue)) break;
                assertion.setState(AssertionResultTo.State.Failure);
                assertion.addFailureMessage("Response header &lt;" + this.htmlKit.escape(headerName) + "&gt; value: &lt;" + this.htmlKit.escape(headerValue) + "&gt; is not greater or equal to: &lt;" + this.htmlKit.escape(expectedHeaderValue) + "&gt;.");
                break;
            }
        }
        return Promises.of();
    }

    private int compare(String v1, String v2) {
        if (!StringUtils.isBlank(v1) && !StringUtils.isBlank(v2)) {
            Maybe<Integer> result = Maybe.ofThrowable(new BiFunction<String, String, Integer>(){

                @Override
                public Integer apply(String firstParam, String secondParam) {
                    Long l1 = Long.valueOf(firstParam);
                    Long l2 = Long.valueOf(secondParam);
                    return l1.compareTo(l2);
                }
            }, v1, v2);
            if (result.isPresent()) {
                return result.get();
            }
            result = Maybe.ofThrowable(new BiFunction<String, String, Integer>(){

                @Override
                public Integer apply(String firstParam, String secondParam) {
                    Double d1 = Double.valueOf(firstParam);
                    Double d2 = Double.valueOf(secondParam);
                    return d1.compareTo(d2);
                }
            }, v1, v2);
            if (result.isPresent()) {
                return result.get();
            }
            Date d1 = this.httpDate.valueOf(v1);
            Date d2 = this.httpDate.valueOf(v2);
            if (d1 != null && d2 != null) {
                return d1.compareTo(d2);
            }
            return v1.compareToIgnoreCase(v2);
        }
        if (StringUtils.isBlank(v1) && StringUtils.isBlank(v2)) {
            return 0;
        }
        if (!StringUtils.isBlank(v1)) {
            return 1;
        }
        return -1;
    }
}

