/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.Predicate;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    private static <T> EqualityFunction<T> objectEquals() {
        return new EqualityFunction<T>(){

            @Override
            public boolean equals(T a, T b) {
                return Objects.equals(a, b);
            }
        };
    }

    public static <T> CollectionDiff<T> diff(Collection<T> left, Collection<T> right) {
        return new CollectionDiff(left, right, CollectionUtils.objectEquals());
    }

    public static <T> CollectionDiff<T> diff(List<T> left, List<T> right) {
        return new CollectionDiff(left, right, CollectionUtils.objectEquals());
    }

    public static <T> CollectionDiff<T> diff(Collection<T> left, Collection<T> right, EqualityFunction<T> equalityFunction) {
        return new CollectionDiff(left, right, equalityFunction);
    }

    public static <T> CollectionDiff<T> diff(List<T> left, List<T> right, EqualityFunction<T> equalityFunction) {
        return new CollectionDiff(left, right, equalityFunction);
    }

    private static class SpecialEqualsList<T>
    extends ArrayList<T> {
        EqualityFunction<T> equalityFunction;

        SpecialEqualsList(Collection<? extends T> c, EqualityFunction<T> equalityFunction) {
            super(c);
            this.equalityFunction = equalityFunction;
        }

        SpecialEqualsList(EqualityFunction<T> equalityFunction) {
            this.equalityFunction = equalityFunction;
        }

        private SpecialEqualsList() {
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    Object left;
                    try {
                        left = o;
                    }
                    catch (Exception e) {
                        return -1;
                    }
                    if (!this.equalityFunction.equals(left, this.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    public static class CollectionDiff<T> {
        public final Set<T> onlyInLeft = new LinkedHashSet<T>();
        public final Set<T> onlyInRight = new LinkedHashSet<T>();
        public final Set<T> inBoth = new LinkedHashSet<T>();

        private CollectionDiff(Collection<T> left, Collection<T> right, EqualityFunction<T> equalityFunction) {
            final SpecialEqualsList failSafeLeft = Objects.firstNonNull(new SpecialEqualsList<T>(left, equalityFunction), new SpecialEqualsList<T>(equalityFunction));
            SpecialEqualsList<T> failSafeRight = Objects.firstNonNull(new SpecialEqualsList<T>(right, equalityFunction), new SpecialEqualsList<T>(equalityFunction));
            for (Object element : failSafeLeft) {
                if (failSafeRight.contains(element)) {
                    this.inBoth.add(element);
                    continue;
                }
                this.onlyInLeft.add(element);
            }
            this.onlyInRight.addAll(Sequence.of(failSafeRight).filter(new Predicate<T>(){

                @Override
                public boolean test(T rightElement) {
                    return !failSafeLeft.contains(rightElement);
                }
            }).toList());
        }

        public boolean hasNoDiff() {
            return this.onlyInLeft.isEmpty() && this.onlyInRight.isEmpty();
        }
    }

    public static class CollectionPatchConfiguration<T> {
        public final SpecialEqualsList<T> toBeAdded;
        public final SpecialEqualsList<T> toBeRemoved;
        public final SpecialEqualsList<T> toBeUpdated;

        public CollectionPatchConfiguration() {
            this(CollectionUtils.objectEquals());
        }

        public CollectionPatchConfiguration(EqualityFunction<T> equalityFunction) {
            this.toBeAdded = new SpecialEqualsList<T>(equalityFunction);
            this.toBeRemoved = new SpecialEqualsList<T>(equalityFunction);
            this.toBeUpdated = new SpecialEqualsList<T>(equalityFunction);
        }

        public boolean addInToBeAdded(T newElement) {
            return this.addIfNotPresent(this.toBeAdded, newElement);
        }

        public boolean addInToBeRemoved(T newElement) {
            return this.addIfNotPresent(this.toBeRemoved, newElement);
        }

        public boolean addInToBeUpdated(T newElement) {
            return this.addIfNotPresent(this.toBeUpdated, newElement);
        }

        private boolean addIfNotPresent(SpecialEqualsList<T> list, T newElement) {
            return !list.contains(newElement) && list.add(newElement);
        }
    }

    public static interface EqualityFunction<T>
    extends Serializable {
        public boolean equals(T var1, T var2);
    }
}

