/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import java.util.Comparator;

public class Comparables<T> {
    Comparator<T> comparator;
    T left;

    private Comparables(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public static <T> ComparablesBuilder<T> does(Comparator<T> comparator) {
        Comparables<T> comparables = new Comparables<T>(comparator);
        return new ComparablesBuilder<T>(comparables);
    }

    public boolean asGreaterThan(T right) {
        return this.comparator.compare(this.left, right) > 0;
    }

    public boolean asGreaterThanOrEqualTo(T right) {
        int comparison = this.comparator.compare(this.left, right);
        return comparison >= 0;
    }

    public boolean asLowerThan(T right) {
        return this.comparator.compare(this.left, right) < 0;
    }

    public boolean asLowerThanOrEqualTo(T right) {
        int comparison = this.comparator.compare(this.left, right);
        return comparison <= 0;
    }

    public static class ComparablesBuilder<T> {
        Comparables<T> comparables;

        public ComparablesBuilder(Comparables<T> comparables) {
            this.comparables = comparables;
        }

        public Comparables<T> evaluate(T left) {
            this.comparables.left = left;
            return this.comparables;
        }
    }
}

