/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Function;
import com.restlet.client.model.EntityTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.tests.ScenarioTo;
import com.restlet.client.utils.EntityUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ComparatorUtils {
    public static BiFunction<EntityTo, EntityTo, Boolean> equalityMatcherById = new BiFunction<EntityTo, EntityTo, Boolean>(){

        @Override
        public Boolean apply(EntityTo e1, EntityTo e2) {
            return Objects.equals(e1.getId(), e2.getId());
        }
    };

    public static void sortHttpRequests(ScenarioTo scenarioTo, List<HttpRequestTo> httpRequests) {
        if (scenarioTo == null) {
            return;
        }
        ComparatorUtils.sortAsScenarioRequests(httpRequests, scenarioTo, new Function<HttpRequestTo, String>(){

            @Override
            public String apply(HttpRequestTo requestTo) {
                return requestTo.getName();
            }
        });
    }

    public static <T> void sortAsScenarioRequests(List<T> toSort, final ScenarioTo scenarioTo, final Function<T, String> nameMapper) {
        if (scenarioTo == null || toSort == null) {
            return;
        }
        Collections.sort(toSort, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int index1 = EntityUtils.indexOf(scenarioTo, (String)nameMapper.apply(o1));
                int index2 = EntityUtils.indexOf(scenarioTo, (String)nameMapper.apply(o2));
                return index1 - index2;
            }
        });
    }
}

