/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.Consumer;
import com.restlet.client.function.Executor;
import com.restlet.client.function.Function;
import com.restlet.client.function.Supplier;
import com.restlet.client.utils.Iterables;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Pair;
import com.restlet.client.utils.Sequence;
import java.util.Collection;
import java.util.List;

public class FunctionalUtils {
    public static <R, T> T ifNotNull(R object, Function<R, T> getter) {
        return FunctionalUtils.ifNotNull(object, getter, null);
    }

    public static <R, T> T ifNotNull(R object, Function<R, T> getter, T fallback) {
        return object == null ? fallback : getter.apply(object);
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T input) {
                return input;
            }
        };
    }

    public static <T> void doIfNotNull(T object, Consumer<T> successHandler) {
        FunctionalUtils.doIfNotNull(object, successHandler, FunctionalUtils.noopExecutor());
    }

    public static <T> void doIfNotNull(final T object, final Consumer<T> successHandler, Executor failHandler) {
        FunctionalUtils.doIf(object != null, new Executor(){

            @Override
            public void execute() {
                successHandler.consume(object);
            }
        }, failHandler);
    }

    public static void doIf(boolean condition, Executor successExecutor) {
        FunctionalUtils.doIf(condition, successExecutor, new Executor(){

            @Override
            public void execute() {
            }
        });
    }

    public static void doIf(boolean condition, Executor successExecutor, Executor failureExecutor) {
        if (condition) {
            successExecutor.execute();
        } else {
            failureExecutor.execute();
        }
    }

    public static <T> T doIfOrThrow(boolean condition, Supplier<T> successExecutor, RuntimeException fallbackException) {
        if (condition) {
            return successExecutor.get();
        }
        throw fallbackException;
    }

    public static <T> Consumer<T> noopConsumer() {
        return new Consumer<T>(){

            @Override
            public void consume(T value) {
            }
        };
    }

    public static Executor noopExecutor() {
        return new Executor(){

            @Override
            public void execute() {
            }
        };
    }

    public static <T> T returnIf(boolean condition, Supplier<T> successSupplier, Supplier<T> failureSupplier) {
        if (condition) {
            return successSupplier.get();
        }
        return failureSupplier.get();
    }

    public static <T> Pair<Maybe<T>, List<T>> headAndTail(Collection<T> inputCollection) {
        Maybe<T> head = Iterables.getFirst(inputCollection);
        List<T> tail = Sequence.of(inputCollection).dropLeft(1).toList();
        return new Pair<Maybe<T>, List<T>>(head, tail);
    }

    public static <T> T firstNotNull(T first, T ... others) {
        if (first != null) {
            return first;
        }
        for (T element : others) {
            if (element == null) continue;
            return element;
        }
        throw new IllegalArgumentException("One input at least should be non-null");
    }
}

