/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

public class IntegerRange {
    final Integer lowerBound;
    final Integer upperBound;

    private IntegerRange(Integer lowerBound, Integer upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static IntegerRange inclusive(Integer lower, Integer upper) {
        return new IntegerRange(lower, upper);
    }

    public boolean isEmpty() {
        return this.lowerBound == null && this.upperBound == null || this.lowerBound != null && this.lowerBound.equals(this.upperBound);
    }

    public Integer lowerEndpoint() {
        return this.lowerBound;
    }

    public Integer upperEndpoint() {
        return this.upperBound;
    }

    public boolean containsInteger(int value) {
        return !(this.lowerBound != null && value < this.lowerBound || this.upperBound != null && value > this.upperBound);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IntegerRange range = (IntegerRange)obj;
        if (this.lowerBound == null ? range.lowerBound != null : range.lowerBound == null) {
            return false;
        }
        if (this.upperBound == null ? range.upperBound != null : range.upperBound == null) {
            return false;
        }
        return (this.lowerBound == null && range.lowerBound == null || this.lowerBound.equals(range.lowerBound)) && (this.upperBound == null && range.upperBound == null || this.upperBound.equals(range.upperBound));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + (this.lowerBound != null ? this.lowerBound.hashCode() : "null".hashCode());
        result = 37 * result + (this.upperBound != null ? this.upperBound.hashCode() : "null".hashCode());
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append(this.getClass().getSimpleName() + "[");
        buf.append(this.lowerBound);
        buf.append(',');
        buf.append(this.upperBound);
        buf.append(']');
        return buf.toString();
    }
}

