/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.function.Supplier;
import com.restlet.client.utils.Objects;
import java.io.Serializable;

public class Maybe<T>
implements Serializable {
    final T value;

    protected Maybe(T value) {
        this.value = value;
    }

    public Maybe() {
        this.value = null;
    }

    public <R> Maybe<R> get(Function<T, R> getter) {
        return Maybe.of(this.isPresent() ? (R)getter.apply(this.get()) : null);
    }

    public static <R> Maybe<R> empty() {
        return new Maybe<Object>(null);
    }

    public static <R> Maybe<R> ofNullable(R r) {
        if (r == null) {
            return Maybe.empty();
        }
        return new Maybe<R>(r);
    }

    public static <R> Maybe<R> ofThrowable(Supplier<R> supplier) {
        try {
            return new Maybe<R>(supplier.get());
        }
        catch (Exception e) {
            return Maybe.empty();
        }
    }

    public static <T, R> Maybe<R> ofThrowable(Function<T, R> f, T input) {
        try {
            return new Maybe<R>(f.apply(input));
        }
        catch (Exception e) {
            return Maybe.empty();
        }
    }

    public static <T, U, R> Maybe<R> ofThrowable(BiFunction<T, U, R> f, T input1, U input2) {
        try {
            return new Maybe<R>(f.apply(input1, input2));
        }
        catch (Exception e) {
            return Maybe.empty();
        }
    }

    public static <R> Maybe<R> of(R r) {
        return new Maybe<R>(Objects.requireNonNull(r));
    }

    public <R> Maybe<R> map(Function<T, R> mapper) {
        if (this.value == null) {
            return Maybe.empty();
        }
        R apply = mapper.apply(this.value);
        if (apply == null) {
            return Maybe.empty();
        }
        return new Maybe<R>(apply);
    }

    public <R> Maybe<R> flatMap(Function<T, Maybe<R>> mapper) {
        if (this.value == null) {
            return Maybe.empty();
        }
        Maybe<R> apply = mapper.apply(this.value);
        if (apply == null) {
            return Maybe.empty();
        }
        return apply;
    }

    public T get() throws NullPointerException {
        Objects.requireNonNull(this.value);
        return this.value;
    }

    public T value() {
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isAbsent() {
        return this.value == null;
    }

    public T orElse(T defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        return this.value;
    }

    public Maybe<T> filter(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isAbsent() || predicate.test(this.value)) {
            return this;
        }
        return Maybe.empty();
    }

    public Maybe<T> ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.consume(this.value);
        }
        return this;
    }

    public String toString() {
        return this.value == null ? "Nothing" : "Just " + String.valueOf(this.value);
    }
}

