/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.utils;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.Function;
import com.restlet.client.model.EntityTo;
import com.restlet.client.model.EntityTreeNode;
import com.restlet.client.model.UpdateType;
import com.restlet.client.utils.Sequence;
import java.util.List;

public class RepositoryUtils {
    public static Promise<EntityTreeNode> readEntityTree(final RepositoryDao repositoryDao, EntityTo wrapperEntity, List<String> rootEntityNames) {
        final EntityTreeNode entityTreeNode = new EntityTreeNode(wrapperEntity, UpdateType.Import, new EntityTreeNode[0]);
        return Promises.all(Sequence.of(rootEntityNames).map(new Function<String, Promise<EntityTreeNode>>(){

            @Override
            public Promise<EntityTreeNode> apply(String name) {
                return repositoryDao.find(name, null).flatMap(new Function<EntityTo, Promise<EntityTreeNode>>(){

                    @Override
                    public Promise<EntityTreeNode> apply(EntityTo persistedRootEntity) {
                        return persistedRootEntity == null ? null : repositoryDao.readEntityTree(persistedRootEntity.getId());
                    }
                });
            }
        }).toList()).map(new Function<List<EntityTreeNode>, EntityTreeNode>(){

            @Override
            public EntityTreeNode apply(List<EntityTreeNode> children) {
                Sequence.of(children).omitNulls().each(new BiConsumer<EntityTreeNode, Integer>(){

                    @Override
                    public void consume(EntityTreeNode child, Integer secondValue) {
                        entityTreeNode.addChild(child);
                    }
                });
                return entityTreeNode;
            }
        });
    }
}

