/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.NumericOperator;

public class DivideOperator
extends NumericOperator {
    public DivideOperator(ExpressionNode left, ExpressionNode right, Location location) {
        super(left, right, "/", location);
    }

    @Override
    public JsonNode perform(JsonNode v1, JsonNode v2) {
        if (v1.isNull() || v2.isNull()) {
            return NullNode.instance;
        }
        v1 = NodeUtils.number(v1, true, this.location);
        v2 = NodeUtils.number(v2, true, this.location);
        if (v1.isIntegralNumber() && v2.isIntegralNumber()) {
            long l2;
            long l1 = v1.longValue();
            if (l1 % (l2 = v2.longValue()) == 0L) {
                return new LongNode(l1 / l2);
            }
            return new DoubleNode((double)l1 / (double)l2);
        }
        return new DoubleNode(this.perform(v1.doubleValue(), v2.doubleValue()));
    }

    @Override
    protected double perform(double v1, double v2) {
        return v1 / v2;
    }

    @Override
    protected long perform(long v1, long v2) {
        return v1 / v2;
    }
}

