//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[CacheControl](../index.md)/[Builder](index.md)/[maxAge](max-age.md)

# maxAge

[jvm]\
fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)

Sets the maximum age of a cached response. If the cache response's age exceeds [maxAge](max-age.md), it will not be used and a network request will be made.

## Parameters

jvm

| | |
|---|---|
| maxAge | a non-negative integer. This is stored and transmitted with [TimeUnit.SECONDS](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html#SECONDS)     precision; finer precision will be lost. |

[common]\
expect fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)

Sets the maximum age of a cached response. If the cache response's age exceeds [maxAge](max-age.md), it will not be used and a network request will be made.

## Parameters

common

| | |
|---|---|
| maxAge | a non-negative integer. This is stored and transmitted with TimeUnit.SECONDS     precision; finer precision will be lost. |

[jvm]\
actual fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)
