//[okhttp](../../../index.md)/[okhttp3](../index.md)/[FormBody](index.md)

# FormBody

[jvm]\
class [FormBody](index.md) : [RequestBody](../-request-body/index.md)

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)?) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [contentLength](content-length.md) | [jvm]<br>open override fun [contentLength](content-length.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes that will be written to sink in a call to [writeTo](write-to.md), or -1 if that count is unknown. |
| [contentType](content-type.md) | [jvm]<br>open override fun [contentType](content-type.md)(): [MediaType](../-media-type/index.md)<br>Returns the Content-Type header for this body. |
| [encodedName](encoded-name.md) | [jvm]<br>fun [encodedName](encoded-name.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [encodedValue](encoded-value.md) | [jvm]<br>fun [encodedValue](encoded-value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [isDuplex](../-request-body/is-duplex.md) | [jvm]<br>open fun [isDuplex](../-request-body/is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>A duplex request body is special in how it is **transmitted** on the network and in the **API contract** between OkHttp and the application. |
| [isOneShot](../-request-body/is-one-shot.md) | [jvm]<br>open fun [isOneShot](../-request-body/is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this body expects at most one call to [writeTo](../-request-body/write-to.md) and can be transmitted at most once. This is typically used when writing the request body is destructive and it is not possible to recreate the request body after it has been sent. |
| [name](name.md) | [jvm]<br>fun [name](name.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [value](value.md) | [jvm]<br>fun [value](value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [writeTo](write-to.md) | [jvm]<br>open override fun [writeTo](write-to.md)(sink: [BufferedSink](https://square.github.io/okio/2.x/okio/okio/-buffered-sink/index.html))<br>Writes the content of this request to [sink](write-to.md). |

## Properties

| Name | Summary |
|---|---|
| [size](size.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")<br>val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The number of key-value pairs in this form-encoded body. |
