//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Protocol](index.md)

# Protocol

[common]\
enum [Protocol](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[Protocol](index.md)&gt; 

Protocols that OkHttp implements for [ALPN](http://tools.ietf.org/html/draft-ietf-tls-applayerprotoneg) selection.

##  Protocol vs Scheme

Despite its name, java.net.URL.getProtocol returns the java.net.URI.getScheme (http, https, etc.) of the URL, not the protocol (http/1.1, spdy/3.1, etc.). OkHttp uses the word *protocol* to identify how HTTP messages are framed.

## Entries

| | |
|---|---|
| [HTTP_3](-h-t-t-p_3/index.md) | [common]<br>[HTTP_3](-h-t-t-p_3/index.md)("h3")<br>HTTP/3 is the third and upcoming major version of the Hypertext Transfer Protocol used to exchange information. HTTP/3 runs over QUIC, which is published as RFC 9000. |
| [QUIC](-q-u-i-c/index.md) | [common]<br>[QUIC](-q-u-i-c/index.md)("quic")<br>QUIC (Quick UDP Internet Connection) is a new multiplexed and secure transport atop UDP, designed from the ground up and optimized for HTTP/2 semantics. HTTP/1.1 semantics are layered on HTTP/2. |
| [H2_PRIOR_KNOWLEDGE](-h2_-p-r-i-o-r_-k-n-o-w-l-e-d-g-e/index.md) | [common]<br>[H2_PRIOR_KNOWLEDGE](-h2_-p-r-i-o-r_-k-n-o-w-l-e-d-g-e/index.md)("h2_prior_knowledge")<br>Cleartext HTTP/2 with no "upgrade" round trip. This option requires the client to have prior knowledge that the server supports cleartext HTTP/2. |
| [HTTP_2](-h-t-t-p_2/index.md) | [common]<br>[HTTP_2](-h-t-t-p_2/index.md)("h2")<br>The IETF's binary-framed protocol that includes header compression, multiplexing multiple requests on the same socket, and server-push. HTTP/1.1 semantics are layered on HTTP/2. |
| [SPDY_3](-s-p-d-y_3/index.md) | [common]<br>[SPDY_3](-s-p-d-y_3/index.md)("spdy/3.1")<br>Chromium's binary-framed protocol that includes header compression, multiplexing multiple requests on the same socket, and server-push. HTTP/1.1 semantics are layered on SPDY/3. |
| [HTTP_1_1](-h-t-t-p_1_1/index.md) | [common]<br>[HTTP_1_1](-h-t-t-p_1_1/index.md)("http/1.1")<br>A plaintext framing that includes persistent connections. |
| [HTTP_1_0](-h-t-t-p_1_0/index.md) | [common]<br>[HTTP_1_0](-h-t-t-p_1_0/index.md)("http/1.0")<br>An obsolete plaintext framing that does not use persistent sockets by default. |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the string used to identify this protocol for ALPN, like "http/1.1", "spdy/3.1" or "h2". |

## Properties

| Name | Summary |
|---|---|
| [name](../-tls-version/-s-s-l_3_0/index.md#-372974862%2FProperties%2F180464967) | [common]<br>val [name](../-tls-version/-s-s-l_3_0/index.md#-372974862%2FProperties%2F180464967): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [ordinal](../-tls-version/-s-s-l_3_0/index.md#-739389684%2FProperties%2F180464967) | [common]<br>val [ordinal](../-tls-version/-s-s-l_3_0/index.md#-739389684%2FProperties%2F180464967): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
