//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Request](index.md)

# Request

[jvm]\
class [Request](index.md)

An HTTP request. Instances of this class are immutable if their [body](body.md) is null or itself immutable.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>open class [Builder](-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [header](header.md) | [jvm]<br>fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [headers](headers.md) | [jvm]<br>fun [headers](headers.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [newBuilder](new-builder.md) | [jvm]<br>fun [newBuilder](new-builder.md)(): [Request.Builder](-builder/index.md) |
| [tag](tag.md) | [jvm]<br>fun [tag](tag.md)(): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>Returns the tag attached with Object.class as a key, or null if no tag is attached with that key.<br>[jvm]<br>fun &lt;[T](tag.md)&gt; [tag](tag.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;out [T](tag.md)&gt;): [T](tag.md)?<br>Returns the tag attached with [type](tag.md) as a key, or null if no tag is attached with that key. |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [body](body.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "body")<br>val [body](body.md): [RequestBody](../-request-body/index.md)? |
| [cacheControl](cache-control.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "cacheControl")<br>val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>Returns the cache control directives for this response. This is never null, even if this response contains no Cache-Control header. |
| [headers](headers.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "headers")<br>val [headers](headers.md): [Headers](../-headers/index.md) |
| [isHttps](is-https.md) | [jvm]<br>val [isHttps](is-https.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [method](method.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "method")<br>val [method](method.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [url](url.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "url")<br>val [url](url.md): [HttpUrl](../-http-url/index.md) |
