//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Response](../index.md)/[Builder](index.md)

# Builder

[jvm]\
open class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | [jvm]<br>open fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Response.Builder](index.md)<br>Adds a header with [name](add-header.md) to [value](add-header.md). Prefer this method for multiply-valued headers like "Set-Cookie". |
| [body](body.md) | [jvm]<br>open fun [body](body.md)(body: [ResponseBody](../../-response-body/index.md)?): [Response.Builder](index.md) |
| [build](build.md) | [jvm]<br>open fun [build](build.md)(): [Response](../index.md) |
| [cacheResponse](cache-response.md) | [jvm]<br>open fun [cacheResponse](cache-response.md)(cacheResponse: [Response](../index.md)?): [Response.Builder](index.md) |
| [code](code.md) | [jvm]<br>open fun [code](code.md)(code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Response.Builder](index.md) |
| [handshake](handshake.md) | [jvm]<br>open fun [handshake](handshake.md)(handshake: [Handshake](../../-handshake/index.md)?): [Response.Builder](index.md) |
| [header](header.md) | [jvm]<br>open fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Response.Builder](index.md)<br>Sets the header named [name](header.md) to [value](header.md). If this request already has any headers with that name, they are all replaced. |
| [headers](headers.md) | [jvm]<br>open fun [headers](headers.md)(headers: [Headers](../../-headers/index.md)): [Response.Builder](index.md)<br>Removes all headers on this builder and adds [headers](headers.md). |
| [message](message.md) | [jvm]<br>open fun [message](message.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Response.Builder](index.md) |
| [networkResponse](network-response.md) | [jvm]<br>open fun [networkResponse](network-response.md)(networkResponse: [Response](../index.md)?): [Response.Builder](index.md) |
| [priorResponse](prior-response.md) | [jvm]<br>open fun [priorResponse](prior-response.md)(priorResponse: [Response](../index.md)?): [Response.Builder](index.md) |
| [protocol](protocol.md) | [jvm]<br>open fun [protocol](protocol.md)(protocol: Protocol): [Response.Builder](index.md) |
| [receivedResponseAtMillis](received-response-at-millis.md) | [jvm]<br>open fun [receivedResponseAtMillis](received-response-at-millis.md)(receivedResponseAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Response.Builder](index.md) |
| [removeHeader](remove-header.md) | [jvm]<br>open fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Response.Builder](index.md)<br>Removes all headers named [name](remove-header.md) on this builder. |
| [request](request.md) | [jvm]<br>open fun [request](request.md)(request: [Request](../../-request/index.md)): [Response.Builder](index.md) |
| [sentRequestAtMillis](sent-request-at-millis.md) | [jvm]<br>open fun [sentRequestAtMillis](sent-request-at-millis.md)(sentRequestAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Response.Builder](index.md) |
