/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.provider;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CvmRoleCredential
extends Credential {
    private static final String ENDPOINT = "http://metadata.tencentyun.com/latest/meta-data/cam/security-credentials/";
    private static final int EXPIRED_TIME = 300;
    private String roleName;
    private String secretId;
    private String secretKey;
    private String token;
    private int expiredTime;

    public CvmRoleCredential() {
    }

    public CvmRoleCredential(String roleName) {
        this.roleName = roleName;
    }

    private void updateCredential() throws TencentCloudSDKException {
        String resp;
        Map maps;
        if (this.roleName == null) {
            this.roleName = this.loadJson(ENDPOINT);
        }
        if (!(maps = (Map)new Gson().fromJson(resp = this.loadJson(ENDPOINT + this.roleName), new TypeToken<HashMap<String, Object>>(){}.getType())).get("Code").equals("Success")) {
            throw new TencentCloudSDKException("CVM role token data failed");
        }
        this.secretId = (String)maps.get("TmpSecretId");
        this.secretKey = (String)maps.get("TmpSecretKey");
        this.token = (String)maps.get("Token");
        this.expiredTime = ((Double)maps.get("ExpiredTime")).intValue();
    }

    @Override
    public String getSecretId() {
        if (this.secretId == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.secretId;
    }

    @Override
    public String getSecretKey() {
        if (this.secretKey == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.secretKey;
    }

    @Override
    public String getToken() {
        if (this.token == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.token;
    }

    private boolean needRefresh() {
        return (long)this.expiredTime - new Date().getTime() / 1000L <= 300L;
    }

    private String loadJson(String url) throws TencentCloudSDKException {
        StringBuilder json = new StringBuilder();
        try {
            URL urlObject = new URL(url);
            HttpURLConnection uc = (HttpURLConnection)urlObject.openConnection();
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader(uc.getInputStream(), "utf-8"));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                json.append(inputLine);
            }
            in.close();
            uc.disconnect();
        }
        catch (Exception e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return json.toString();
    }
}

