/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.Scenario;
import com.thoughtworks.gauge.Specification;
import com.thoughtworks.gauge.StepDetails;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ExecutionContext {
    private final Specification currentSpecification;
    private final Scenario currentScenario;
    private final StepDetails currentStep;

    public ExecutionContext(Specification specification, Scenario scenario, StepDetails stepDetails) {
        this.currentSpecification = specification;
        this.currentScenario = scenario;
        this.currentStep = stepDetails;
    }

    public ExecutionContext() {
        this.currentSpecification = new Specification();
        this.currentScenario = new Scenario();
        this.currentStep = new StepDetails();
    }

    public Specification getCurrentSpecification() {
        return this.currentSpecification;
    }

    public Scenario getCurrentScenario() {
        return this.currentScenario;
    }

    public StepDetails getCurrentStep() {
        return this.currentStep;
    }

    public List<String> getAllTags() {
        HashSet<String> specTags = new HashSet<String>(this.currentSpecification.getTags());
        specTags.addAll(this.currentScenario.getTags());
        return new ArrayList<String>(specTags);
    }
}

