/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.types;

import com.thoughtworks.gauge.execution.parameters.parsers.converters.StringToPrimitiveConverter;
import gauge.messages.Spec;
import java.util.HashMap;
import java.util.Map;

public class PrimitivesConverter {
    private final Map<Class<?>, StringToPrimitiveConverter> primitiveConverters = new HashMap();

    public PrimitivesConverter() {
        this.primitiveConverters.put(Integer.TYPE, source -> Integer.parseInt(source.getValue()));
        this.primitiveConverters.put(Integer.class, source -> Integer.parseInt(source.getValue()));
        this.primitiveConverters.put(Boolean.TYPE, source -> Boolean.parseBoolean(source.getValue()));
        this.primitiveConverters.put(Boolean.class, source -> Boolean.parseBoolean(source.getValue()));
        this.primitiveConverters.put(Long.TYPE, source -> Long.parseLong(source.getValue()));
        this.primitiveConverters.put(Long.class, source -> Long.parseLong(source.getValue()));
        this.primitiveConverters.put(Float.TYPE, source -> Float.valueOf(Float.parseFloat(source.getValue())));
        this.primitiveConverters.put(Float.class, source -> Float.valueOf(Float.parseFloat(source.getValue())));
        this.primitiveConverters.put(Double.TYPE, source -> Double.parseDouble(source.getValue()));
        this.primitiveConverters.put(Double.class, source -> Double.parseDouble(source.getValue()));
    }

    public boolean contains(Class<?> parameterType) {
        return this.primitiveConverters.containsKey(parameterType);
    }

    public Object convert(Class<?> parameterType, Spec.Parameter parameter) throws Exception {
        return this.primitiveConverters.get(parameterType).convert(parameter);
    }
}

