/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.Util;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.StepsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class RegistryMethodVisitor
extends VoidVisitorAdapter<Void> {
    private final StepRegistry stepRegistry;
    private final String file;

    public RegistryMethodVisitor(StepRegistry stepRegistry, String file) {
        this.stepRegistry = stepRegistry;
        this.file = file;
    }

    public void visit(MethodDeclaration methodDeclaration, Void ignored) {
        NodeList annotations = methodDeclaration.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationExpr annotationExpr : annotations) {
            if (!(annotationExpr instanceof SingleMemberAnnotationExpr)) continue;
            SingleMemberAnnotationExpr annotation = (SingleMemberAnnotationExpr)annotationExpr;
            Expression expression = annotation.getMemberValue();
            if (expression instanceof ArrayInitializerExpr) {
                ArrayInitializerExpr memberValue = (ArrayInitializerExpr)expression;
                for (Expression expression2 : memberValue.getValues()) {
                    this.addStepToRegistry(expression2, methodDeclaration, annotation);
                }
                continue;
            }
            this.addStepToRegistry(annotation.getMemberValue(), methodDeclaration, annotation);
        }
    }

    private void addStepToRegistry(Expression expression, MethodDeclaration methodDeclaration, SingleMemberAnnotationExpr annotation) {
        String parameterizedStep = this.getParameterizedStep(expression);
        String stepText = new StepsUtil().getStepText(parameterizedStep);
        StepValue stepValue = new StepValue(stepText, parameterizedStep);
        StepRegistryEntry entry = new StepRegistryEntry();
        entry.setName(methodDeclaration.getDeclarationAsString());
        String className = this.getClassName(methodDeclaration);
        String fullyQualifiedName = className == null ? methodDeclaration.getNameAsString() : className + "." + methodDeclaration.getNameAsString();
        entry.setFullyQualifiedName(fullyQualifiedName);
        entry.setStepText(parameterizedStep);
        entry.setStepValue(stepValue);
        entry.setParameters((List<Parameter>)methodDeclaration.getParameters());
        entry.setSpan((Range)methodDeclaration.getRange().get());
        entry.setHasAlias(this.hasAlias(annotation));
        entry.setAliases(this.getAliases(annotation));
        entry.setFileName(this.file);
        this.stepRegistry.addStep(stepValue, entry);
    }

    private String getClassName(MethodDeclaration methodDeclaration) {
        String packageNameStr;
        String classNameStr;
        AtomicReference className = new AtomicReference();
        methodDeclaration.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).ifPresent(c -> className.set(c.getNameAsString()));
        String string = classNameStr = className.get() == null ? null : (String)className.get();
        if (classNameStr == null) {
            return null;
        }
        AtomicReference packageName = new AtomicReference();
        methodDeclaration.findCompilationUnit().flatMap(CompilationUnit::getPackageDeclaration).ifPresent(p -> packageName.set(p.getName()));
        String string2 = packageNameStr = packageName.get() == null ? null : ((Name)packageName.get()).asString();
        if (packageNameStr == null) {
            return classNameStr;
        }
        return packageNameStr + "." + classNameStr;
    }

    private String getParameterizedStep(Expression expression) {
        if (expression instanceof BinaryExpr) {
            BinaryExpr expr = (BinaryExpr)expression;
            return Util.trimQuotes(expr.getLeft().toString()) + Util.trimQuotes(expr.getRight().toString());
        }
        return Util.trimQuotes(expression.toString());
    }

    private Boolean hasAlias(SingleMemberAnnotationExpr annotation) {
        return annotation.getMemberValue() instanceof ArrayInitializerExpr;
    }

    private List<String> getAliases(SingleMemberAnnotationExpr annotation) {
        ArrayList<String> aliases = new ArrayList<String>();
        Expression expression = annotation.getMemberValue();
        if (expression instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr memberValue = (ArrayInitializerExpr)expression;
            for (Expression expression2 : memberValue.getValues()) {
                aliases.add(this.getParameterizedStep(expression2));
            }
        }
        return aliases;
    }
}

