/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeValueResolver<T> {
    public static final AttributeValueResolver<String> STRING_RESOLVER = new AttributeValueResolver<String>(){

        @Override
        public String toInstance(SCIMAttributeValue value) {
            return value.getStringValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, String value) {
            return SCIMAttributeValue.createStringValue(value);
        }
    };
    public static final AttributeValueResolver<Date> DATE_RESOLVER = new AttributeValueResolver<Date>(){

        @Override
        public Date toInstance(SCIMAttributeValue value) {
            return value.getDateValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Date value) {
            return SCIMAttributeValue.createDateValue(value);
        }
    };
    public static final AttributeValueResolver<Boolean> BOOLEAN_RESOLVER = new AttributeValueResolver<Boolean>(){

        @Override
        public Boolean toInstance(SCIMAttributeValue value) {
            return value.getBooleanValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Boolean value) {
            return SCIMAttributeValue.createBooleanValue(value);
        }
    };
    public static final AttributeValueResolver<byte[]> BINARY_RESOLVER = new AttributeValueResolver<byte[]>(){

        @Override
        public byte[] toInstance(SCIMAttributeValue value) {
            return value.getBinaryValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, byte[] value) {
            return SCIMAttributeValue.createBinaryValue(value);
        }
    };
    public static final AttributeValueResolver<Double> DECIMAL_RESOLVER = new AttributeValueResolver<Double>(){

        @Override
        public Double toInstance(SCIMAttributeValue value) {
            return value.getDecimalValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Double value) {
            return SCIMAttributeValue.createStringValue(String.valueOf(value));
        }
    };
    public static final AttributeValueResolver<Long> INTEGER_RESOLVER = new AttributeValueResolver<Long>(){

        @Override
        public Long toInstance(SCIMAttributeValue value) {
            return value.getIntegerValue();
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Long value) {
            return SCIMAttributeValue.createStringValue(String.valueOf(value));
        }
    };

    public abstract T toInstance(SCIMAttributeValue var1);

    public abstract SCIMAttributeValue fromInstance(AttributeDescriptor var1, T var2) throws InvalidResourceException;
}

