/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseResource
implements SCIMResponse {
    public static final ResourceFactory<BaseResource> BASE_RESOURCE_FACTORY = new ResourceFactory<BaseResource>(){

        @Override
        public BaseResource createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new BaseResource(resourceDescriptor, scimObject);
        }
    };
    private final ResourceDescriptor resourceDescriptor;
    private final SCIMObject scimObject;

    public BaseResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
        this.resourceDescriptor = resourceDescriptor;
        this.scimObject = scimObject;
    }

    public BaseResource(ResourceDescriptor resourceDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
        this.scimObject = new SCIMObject();
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public SCIMObject getScimObject() {
        return this.scimObject;
    }

    public String getId() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "id", AttributeValueResolver.STRING_RESOLVER);
    }

    public void setId(String id) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "id", AttributeValueResolver.STRING_RESOLVER, id);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public String getExternalId() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "externalId", AttributeValueResolver.STRING_RESOLVER);
    }

    public void setExternalId(String externalId) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "externalId", AttributeValueResolver.STRING_RESOLVER, externalId);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta getMeta() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "meta", Meta.META_RESOLVER);
    }

    public void setMeta(Meta meta) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "meta", Meta.META_RESOLVER, meta);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getSingularAttributeValue(String schema, String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue value;
        SCIMAttribute attribute = this.scimObject.getAttribute(schema, name);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return resolver.toInstance(value);
        }
        return null;
    }

    public <T> void setSingularAttributeValue(String schema, String name, AttributeValueResolver<T> resolver, T value) throws InvalidResourceException {
        if (value == null) {
            this.scimObject.removeAttribute(schema, name);
            return;
        }
        AttributeDescriptor attributeDescriptor = this.getResourceDescriptor().getAttribute(schema, name);
        this.scimObject.setAttribute(SCIMAttribute.create(attributeDescriptor, resolver.fromInstance(attributeDescriptor, value)));
    }

    public <T> Collection<T> getAttributeValues(String schema, String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue[] values;
        SCIMAttribute attribute = this.scimObject.getAttribute(schema, name);
        if (attribute != null && (values = attribute.getValues()) != null) {
            ArrayList<T> entries = new ArrayList<T>(values.length);
            for (SCIMAttributeValue v : values) {
                entries.add(resolver.toInstance(v));
            }
            return entries;
        }
        return null;
    }

    public <T> void setAttributeValues(String schema, String name, AttributeValueResolver<T> resolver, Collection<T> values) throws InvalidResourceException {
        if (values == null) {
            this.scimObject.removeAttribute(schema, name);
            return;
        }
        AttributeDescriptor attributeDescriptor = this.getResourceDescriptor().getAttribute(schema, name);
        SCIMAttributeValue[] entries = new SCIMAttributeValue[values.size()];
        int i = 0;
        for (T value : values) {
            entries[i++] = resolver.fromInstance(attributeDescriptor, value);
        }
        this.scimObject.setAttribute(SCIMAttribute.create(attributeDescriptor, entries));
    }

    @Override
    public void marshal(Marshaller marshaller, OutputStream outputStream) throws Exception {
        marshaller.marshal(this, outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseResource)) {
            return false;
        }
        BaseResource that = (BaseResource)o;
        if (!this.resourceDescriptor.equals(that.resourceDescriptor)) {
            return false;
        }
        return this.scimObject.equals(that.scimObject);
    }

    public int hashCode() {
        int result = this.resourceDescriptor.hashCode();
        result = 31 * result + this.scimObject.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaseResource");
        sb.append("{resource=").append(this.resourceDescriptor.getSchema());
        sb.append(':');
        sb.append(this.resourceDescriptor.getName());
        sb.append(", scimObject=").append(this.scimObject);
        sb.append('}');
        return sb.toString();
    }
}

