/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.schema;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptor
extends BaseResource {
    public static final ResourceFactory<ResourceDescriptor> RESOURCE_DESCRIPTOR_FACTORY = new ResourceFactory<ResourceDescriptor>(){

        @Override
        public ResourceDescriptor createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new ResourceDescriptor(resourceDescriptor, scimObject);
        }
    };
    private Map<String, Map<String, AttributeDescriptor>> attributesCache;

    ResourceDescriptor(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
        super(resourceDescriptor, scimObject);
    }

    private ResourceDescriptor(ResourceDescriptor resourceDescriptor) {
        super(resourceDescriptor);
    }

    public AttributeDescriptor getAttribute(String schema, String name) throws InvalidResourceException {
        this.initAttributesCache();
        AttributeDescriptor attributeDescriptor = null;
        Map<String, AttributeDescriptor> map = this.attributesCache.get(StaticUtils.toLowerCase(schema));
        if (map != null) {
            attributeDescriptor = map.get(StaticUtils.toLowerCase(name));
        }
        if (attributeDescriptor == null) {
            throw new InvalidResourceException("Attribute " + schema + ':' + name + " is not defined for resource " + this.getName());
        }
        return attributeDescriptor;
    }

    public Collection<AttributeDescriptor> getAttributes(String schema) {
        this.initAttributesCache();
        Map<String, AttributeDescriptor> map = this.attributesCache.get(StaticUtils.toLowerCase(schema));
        if (map != null) {
            return map.values();
        }
        return null;
    }

    public Set<String> getAttributeSchemas() {
        this.initAttributesCache();
        return this.attributesCache.keySet();
    }

    public String getName() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "name", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setName(String name) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", AttributeValueResolver.STRING_RESOLVER, name);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Collection<AttributeDescriptor> getAttributes() {
        return this.getAttributeValues("urn:scim:schemas:core:1.0", "attributes", AttributeDescriptor.ATTRIBUTE_DESCRIPTOR_RESOLVER);
    }

    private ResourceDescriptor setAttributes(Collection<AttributeDescriptor> attributes) {
        try {
            this.setAttributeValues("urn:scim:schemas:core:1.0", "attributes", AttributeDescriptor.ATTRIBUTE_DESCRIPTOR_RESOLVER, attributes);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getSchema() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "schema", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setSchema(String schema) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "schema", AttributeValueResolver.STRING_RESOLVER, schema);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getDescription() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "description", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setDescription(String description) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "description", AttributeValueResolver.STRING_RESOLVER, description);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getEndpoint() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "endpoint", AttributeValueResolver.STRING_RESOLVER);
    }

    private ResourceDescriptor setEndpoint(String endpoint) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "endpoint", AttributeValueResolver.STRING_RESOLVER, endpoint);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributesCache() {
        ResourceDescriptor resourceDescriptor = this;
        synchronized (resourceDescriptor) {
            if (this.attributesCache == null) {
                this.attributesCache = new HashMap<String, Map<String, AttributeDescriptor>>();
                for (AttributeDescriptor attributeDescriptor : this.getAttributes()) {
                    String lowerCaseSchema = StaticUtils.toLowerCase(attributeDescriptor.getSchema());
                    Map<String, AttributeDescriptor> map = this.attributesCache.get(lowerCaseSchema);
                    if (map == null) {
                        map = new HashMap<String, AttributeDescriptor>();
                        this.attributesCache.put(lowerCaseSchema, map);
                    }
                    map.put(StaticUtils.toLowerCase(attributeDescriptor.getName()), attributeDescriptor);
                }
            }
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode += StaticUtils.toLowerCase(this.getSchema()).hashCode();
        return hashCode += StaticUtils.toLowerCase(this.getName()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceDescriptor)) {
            return false;
        }
        ResourceDescriptor that = (ResourceDescriptor)obj;
        String thisSchema = this.getSchema();
        String thisName = this.getName();
        String thatSchema = that.getSchema();
        String thatName = that.getName();
        if (thisSchema == null && thatSchema == null) {
            return thisName.equalsIgnoreCase(thatName);
        }
        return thisSchema != null && thatSchema != null && thisSchema.equalsIgnoreCase(thatSchema) && thisName.equalsIgnoreCase(thatName);
    }

    @Override
    public String toString() {
        return "ResourceDescriptor{name='" + this.getName() + '\'' + ", description='" + this.getDescription() + ", schema='" + this.getSchema() + '\'' + ", endpoint='" + this.getEndpoint() + '\'' + ", attributes=" + this.getAttributes() + '}';
    }

    public static ResourceDescriptor create(String name, String description, String schema, String endpoint, AttributeDescriptor ... attributes) {
        ResourceDescriptor resourceDescriptor = new ResourceDescriptor(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR);
        resourceDescriptor.setName(name);
        resourceDescriptor.setDescription(description);
        resourceDescriptor.setSchema(schema);
        resourceDescriptor.setEndpoint(endpoint);
        resourceDescriptor.setAttributes(CoreSchema.addCommonResourceAttributes(attributes));
        return resourceDescriptor;
    }
}

