/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;

public class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    private final AuthScheme authScheme;
    private final Credentials credentials;

    public PreemptiveAuthInterceptor(AuthScheme authScheme, Credentials credentials) {
        if (authScheme == null) {
            throw new NullPointerException("The 'authScheme' parameter cannot be null");
        }
        if (credentials == null) {
            throw new NullPointerException("The 'credentials' parameter cannot be null");
        }
        this.authScheme = authScheme;
        this.credentials = credentials;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState != null) {
            authState.setAuthScheme(this.authScheme);
            authState.setCredentials(this.credentials);
        }
    }
}

