/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SimpleValue;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCIMAttributeValue {
    private final SimpleValue value;
    private final Map<String, SCIMAttribute> attributes;

    public SCIMAttributeValue(SimpleValue value) {
        this.value = value;
        this.attributes = null;
    }

    private SCIMAttributeValue(Map<String, SCIMAttribute> attributes) {
        this.value = null;
        this.attributes = attributes;
    }

    public static SCIMAttributeValue createValue(AttributeDescriptor.DataType dataType, String value) {
        switch (dataType) {
            case BINARY: {
                return SCIMAttributeValue.createBinaryValue(DatatypeConverter.parseBase64Binary((String)value));
            }
        }
        return SCIMAttributeValue.createStringValue(value);
    }

    public static SCIMAttributeValue createStringValue(String value) {
        return new SCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createBooleanValue(Boolean value) {
        return new SCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createDateValue(Date value) {
        return new SCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createBinaryValue(byte[] value) {
        return new SCIMAttributeValue(new SimpleValue(value));
    }

    public <T> T getSubAttributeValue(String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue v;
        SCIMAttribute attribute = this.getAttribute(name);
        if (attribute != null && (v = attribute.getValue()) != null) {
            return resolver.toInstance(v);
        }
        return null;
    }

    public <T> Collection<T> getSubAttributeValues(String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue[] values;
        SCIMAttribute attribute = this.getAttribute(name);
        if (attribute != null && (values = attribute.getValues()) != null) {
            ArrayList<T> entries = new ArrayList<T>(values.length);
            for (SCIMAttributeValue v : values) {
                entries.add(resolver.toInstance(v));
            }
            return entries;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SCIMAttributeValue{");
        if (this.value != null) {
            sb.append("value=").append(this.value);
        } else {
            sb.append("attributes=").append(this.attributes);
        }
        sb.append('}');
        return sb.toString();
    }

    public static SCIMAttributeValue createComplexValue(SCIMAttribute ... attributes) {
        LinkedHashMap<String, SCIMAttribute> map = new LinkedHashMap<String, SCIMAttribute>();
        for (SCIMAttribute a : attributes) {
            String lowerCaseName = StaticUtils.toLowerCase(a.getName());
            if (map.containsKey(lowerCaseName)) {
                throw new RuntimeException("Duplicate attribute " + a.getName() + " in complex attribute value");
            }
            map.put(lowerCaseName, a);
        }
        return new SCIMAttributeValue(Collections.unmodifiableMap(map));
    }

    public static SCIMAttributeValue createComplexValue(Collection<SCIMAttribute> attributes) {
        LinkedHashMap<String, SCIMAttribute> map = new LinkedHashMap<String, SCIMAttribute>();
        for (SCIMAttribute a : attributes) {
            String lowerCaseName = StaticUtils.toLowerCase(a.getName());
            if (map.containsKey(lowerCaseName)) {
                throw new RuntimeException("Duplicate attribute " + a.getName() + " in complex attribute value");
            }
            map.put(lowerCaseName, a);
        }
        return new SCIMAttributeValue(Collections.unmodifiableMap(map));
    }

    public boolean isComplex() {
        return this.value == null;
    }

    public SimpleValue getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value.getStringValue();
    }

    public Boolean getBooleanValue() {
        return this.value.getBooleanValue();
    }

    public Double getDecimalValue() {
        return this.value.getDoubleValue();
    }

    public Long getIntegerValue() {
        return this.value.getLongValue();
    }

    public Date getDateValue() {
        return this.value.getDateValue();
    }

    public byte[] getBinaryValue() {
        return this.value.getBinaryValue();
    }

    public Map<String, SCIMAttribute> getAttributes() {
        return this.attributes;
    }

    public SCIMAttribute getAttribute(String attributeName) {
        if (this.attributes != null) {
            return this.attributes.get(StaticUtils.toLowerCase(attributeName));
        }
        return null;
    }

    public boolean hasAttribute(String attributeName) {
        if (this.attributes != null) {
            return this.attributes.containsKey(StaticUtils.toLowerCase(attributeName));
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCIMAttributeValue that = (SCIMAttributeValue)o;
        if (this.attributes != null ? !((Object)this.attributes).equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        return result;
    }
}

