/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMService;
import com.unboundid.scim.sdk.SortParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpException;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientConfigException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.ClientWebException;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMEndpoint<R extends BaseResource> {
    private final SCIMService scimService;
    private final ResourceDescriptor resourceDescriptor;
    private final ResourceFactory<R> resourceFactory;
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;
    private final MediaType contentType;
    private final MediaType acceptType;
    private final boolean[] overrides = new boolean[3];
    private final RestClient client;

    SCIMEndpoint(SCIMService scimService, RestClient restClient, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) {
        this.scimService = scimService;
        this.client = restClient;
        this.resourceDescriptor = resourceDescriptor;
        this.resourceFactory = resourceFactory;
        this.contentType = scimService.getContentType();
        this.acceptType = scimService.getAcceptType();
        this.overrides[0] = scimService.isOverridePut();
        this.overrides[1] = scimService.isOverridePatch();
        this.overrides[2] = scimService.isOverrideDelete();
        this.marshaller = scimService.getContentType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonMarshaller() : new XmlMarshaller();
        this.unmarshaller = scimService.getAcceptType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonUnmarshaller() : new XmlUnmarshaller();
    }

    public R newResource() {
        return this.resourceFactory.createResource(this.resourceDescriptor, new SCIMObject());
    }

    public R get(String id) throws SCIMException {
        return this.get(id, null, null);
    }

    public R get(String id, String etag, String ... requestedAttributes) throws SCIMException {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.scimService.getBaseURL());
        uriBuilder.path(this.resourceDescriptor.getEndpoint());
        if (id != null) {
            uriBuilder.path(id);
        }
        URI uri = uriBuilder.build(new Object[0]);
        Resource clientResource = this.client.resource(uri);
        clientResource.accept(new MediaType[]{this.acceptType});
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", new String[]{this.scimService.getUserAgent()});
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-None-Match", new String[]{etag});
        }
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.get();
            entity = (InputStream)response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.NOT_MODIFIED) {
                R r = null;
                return r;
            }
            if (response.getStatusType() == Response.Status.OK) {
                R resource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, resource);
                R r = resource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), e.getMessage());
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public Resources<R> query(String filter) throws SCIMException {
        return this.query(filter, null, null, null);
    }

    public Resources<R> query(String filter, SortParameters sortParameters, PageParameters pageParameters, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).build(new Object[0]);
        Resource clientResource = this.client.resource(uri);
        clientResource.accept(new MediaType[]{this.acceptType});
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", new String[]{this.scimService.getUserAgent()});
        }
        if (filter != null) {
            clientResource.queryParam("filter", new Object[]{filter});
        }
        if (sortParameters != null) {
            clientResource.queryParam("sortBy", new Object[]{sortParameters.getSortBy().toString()});
            if (!sortParameters.isAscendingOrder()) {
                clientResource.queryParam("sortOrder", new Object[]{sortParameters.getSortOrder()});
            }
        }
        if (pageParameters != null) {
            clientResource.queryParam("startIndex", new Object[]{String.valueOf(pageParameters.getStartIndex())});
            if (pageParameters.getCount() > 0) {
                clientResource.queryParam("count", new Object[]{String.valueOf(pageParameters.getCount())});
            }
        }
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.get();
            entity = (InputStream)response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                Resources<R> resources = this.unmarshaller.unmarshalResources(entity, this.resourceDescriptor, this.resourceFactory);
                return resources;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), e.getMessage());
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public R create(R resource) throws SCIMException {
        return this.create(resource, null);
    }

    public R create(R resource, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).build(new Object[0]);
        Resource clientResource = this.client.resource(uri);
        clientResource.accept(new MediaType[]{this.acceptType});
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", new String[]{this.scimService.getUserAgent()});
        }
        StreamingOutput output = new StreamingOutput((BaseResource)resource){
            final /* synthetic */ BaseResource val$resource;
            {
                this.val$resource = baseResource;
            }

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    SCIMEndpoint.this.marshaller.marshal(this.val$resource, outputStream);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
        };
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.post((Object)output);
            entity = (InputStream)response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.CREATED) {
                R postedResource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, postedResource);
                R r = postedResource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), e.getMessage());
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public R update(R resource) throws SCIMException {
        return this.update(resource, null, null);
    }

    public R update(R resource, String etag, String ... requestedAttributes) throws SCIMException {
        String id = ((BaseResource)resource).getId();
        if (id == null) {
            throw new InvalidResourceException("Resource must have a valid ID");
        }
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).path(id).build(new Object[0]);
        Resource clientResource = this.client.resource(uri);
        clientResource.accept(new MediaType[]{this.acceptType});
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", new String[]{this.scimService.getUserAgent()});
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-Match", new String[]{etag});
        }
        StreamingOutput output = new StreamingOutput((BaseResource)resource){
            final /* synthetic */ BaseResource val$resource;
            {
                this.val$resource = baseResource;
            }

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    SCIMEndpoint.this.marshaller.marshal(this.val$resource, outputStream);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
        };
        InputStream entity = null;
        try {
            ClientResponse response;
            if (this.overrides[0]) {
                clientResource.header("X-HTTP-Method-Override", new String[]{"PUT"});
                response = clientResource.post((Object)output);
            } else {
                response = clientResource.put((Object)output);
            }
            entity = (InputStream)response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                R postedResource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, postedResource);
                R r = postedResource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), e.getMessage());
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public void delete(String id) throws SCIMException {
        this.delete(id, null);
    }

    public void delete(String id, String etag) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).path(id).build(new Object[0]);
        Resource clientResource = this.client.resource(uri);
        clientResource.accept(new MediaType[]{this.acceptType});
        clientResource.contentType(this.contentType);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", new String[]{this.scimService.getUserAgent()});
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-Match", new String[]{etag});
        }
        InputStream entity = null;
        try {
            ClientResponse response;
            if (this.overrides[2]) {
                clientResource.header("X-HTTP-Method-Override", new String[]{"DELETE"});
                response = clientResource.post(null);
            } else {
                response = clientResource.delete();
            }
            entity = (InputStream)response.getEntity(InputStream.class);
            if (response.getStatusType() != Response.Status.OK) {
                throw this.createErrorResponseException(response, entity);
            }
        }
        catch (SCIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), e.getMessage());
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    private void addAttributesQuery(Resource clientResource, String ... requestedAttributes) {
        if (requestedAttributes != null && requestedAttributes.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < requestedAttributes.length; ++i) {
                stringBuilder.append(requestedAttributes[i]);
                if (i >= requestedAttributes.length - 1) continue;
                stringBuilder.append(",");
            }
            clientResource.queryParam("attributes", new Object[]{stringBuilder.toString()});
        }
    }

    private void addMissingMetaData(ClientResponse response, R resource) {
        Meta meta;
        URI headerLocation = null;
        String headerEtag = null;
        List values = (List)response.getHeaders().get((Object)"Location");
        if (values != null && !values.isEmpty()) {
            headerLocation = URI.create((String)values.get(0));
        }
        if ((values = (List)response.getHeaders().get((Object)"Etag")) != null && !values.isEmpty()) {
            headerEtag = (String)values.get(0);
        }
        if ((meta = ((BaseResource)resource).getMeta()) == null) {
            meta = new Meta(null, null, null, null);
        }
        boolean modified = false;
        if (headerLocation != null && meta.getLocation() == null) {
            meta.setLocation(headerLocation);
            modified = true;
        }
        if (headerEtag != null && meta.getVersion() == null) {
            meta.setVersion(headerEtag);
            modified = true;
        }
        if (modified) {
            ((BaseResource)resource).setMeta(meta);
        }
    }

    private SCIMException createErrorResponseException(ClientResponse response, InputStream entity) {
        SCIMException scimException = null;
        if (entity != null) {
            try {
                scimException = this.unmarshaller.unmarshalError(entity);
            }
            catch (InvalidResourceException e) {
                Debug.debugException(e);
            }
        }
        if (scimException == null) {
            scimException = SCIMException.createException(response.getStatusCode(), response.getMessage());
        }
        return scimException;
    }

    private static int getStatusCode(Exception e) {
        if (e instanceof ClientWebException) {
            ClientWebException cwe = (ClientWebException)e;
            return cwe.getResponse().getStatusCode();
        }
        if (e instanceof ClientAuthenticationException) {
            return 401;
        }
        if (e instanceof ClientConfigException) {
            return 400;
        }
        if (e instanceof ClientRuntimeException) {
            Throwable t = e.getCause();
            if (t instanceof HttpException) {
                return 501;
            }
            if (t instanceof IOException) {
                return 500;
            }
        }
        return 500;
    }
}

