/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.sdk.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticUtils {
    private StaticUtils() {
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] charArray = s.toCharArray();
        block28: for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case 'A': {
                    charArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    charArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    charArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    charArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    charArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    charArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    charArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    charArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    charArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    charArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    charArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    charArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    charArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    charArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    charArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    charArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    charArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    charArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    charArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    charArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    charArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    charArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    charArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    charArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    charArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    charArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (charArray[i] <= '\u007f') continue block28;
                    return s.toLowerCase();
                }
            }
        }
        return new String(charArray);
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(t, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(t.getClass().getSimpleName());
        buffer.append('(');
        String message = t.getMessage();
        if (message != null) {
            buffer.append("message='");
            buffer.append(message);
            buffer.append("', ");
        }
        buffer.append("trace='");
        StaticUtils.getStackTrace(t.getStackTrace(), buffer);
        buffer.append('\'');
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(", cause=");
            StaticUtils.getStackTrace(cause, buffer);
        }
        buffer.append(", revision=");
        buffer.append(948L);
        buffer.append(')');
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(elements, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(StackTraceElement[] elements, StringBuilder buffer) {
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            buffer.append(elements[i].getMethodName());
            buffer.append('(');
            buffer.append(elements[i].getFileName());
            int lineNumber = elements[i].getLineNumber();
            if (lineNumber > 0) {
                buffer.append(':');
                buffer.append(lineNumber);
            }
            buffer.append(')');
        }
    }

    public static int exec(String command, String[] args, File workingDirectory, Map<String, String> environment, List<String> output) throws IOException, SecurityException, InterruptedException {
        ArrayList<String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(command);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                commandAndArgs.add(arg);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandAndArgs);
        processBuilder.redirectErrorStream(true);
        if (workingDirectory != null && workingDirectory.isDirectory()) {
            processBuilder.directory(workingDirectory);
        }
        if (environment != null && !environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        Process process = processBuilder.start();
        InputStream processStream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(processStream));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (output == null) continue;
                output.add(line);
            }
        }
        catch (IOException ioe) {
            try {
                process.destroy();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw ioe;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
        return process.waitFor();
    }
}

