/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Entry<T> {
    public static final AttributeValueResolver<Entry<String>> STRINGS_RESOLVER = new AttributeValueResolver<Entry<String>>(){

        @Override
        public Entry<String> toInstance(SCIMAttributeValue value) {
            String v = (String)value.getSubAttributeValue("value", STRING_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            return new Entry<String>(v, t, p == null ? false : p, d);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<String> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(4);
            if (((Entry)value).value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createStringValue((String)((Entry)value).value)));
            }
            if (((Entry)value).primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(((Entry)value).primary)));
            }
            if (((Entry)value).type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(((Entry)value).type)));
            }
            if (((Entry)value).display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(((Entry)value).display)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<Boolean>> BOOLEANS_RESOLVER = new AttributeValueResolver<Entry<Boolean>>(){

        @Override
        public Entry<Boolean> toInstance(SCIMAttributeValue value) {
            Boolean v = (Boolean)value.getSubAttributeValue("value", BOOLEAN_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            return new Entry<Boolean>(v, t, p == null ? false : p, d);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<Boolean> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(4);
            if (((Entry)value).value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createBooleanValue((Boolean)((Entry)value).value)));
            }
            if (((Entry)value).primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(((Entry)value).primary)));
            }
            if (((Entry)value).type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(((Entry)value).type)));
            }
            if (((Entry)value).display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(((Entry)value).display)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<byte[]>> BINARIES_RESOLVER = new AttributeValueResolver<Entry<byte[]>>(){

        @Override
        public Entry<byte[]> toInstance(SCIMAttributeValue value) {
            byte[] v = (byte[])value.getSubAttributeValue("value", BINARY_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            return new Entry<byte[]>(v, t, p == null ? false : p, d);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<byte[]> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(4);
            if (((Entry)value).value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createBinaryValue((byte[])((Entry)value).value)));
            }
            if (((Entry)value).primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(((Entry)value).primary)));
            }
            if (((Entry)value).type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(((Entry)value).type)));
            }
            if (((Entry)value).display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(((Entry)value).display)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<Date>> DATES_RESOLVER = new AttributeValueResolver<Entry<Date>>(){

        @Override
        public Entry<Date> toInstance(SCIMAttributeValue value) {
            Date v = (Date)value.getSubAttributeValue("value", DATE_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            return new Entry<Date>(v, t, p == null ? false : p, d);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<Date> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(4);
            if (((Entry)value).value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createDateValue((Date)((Entry)value).value)));
            }
            if (((Entry)value).primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(((Entry)value).primary)));
            }
            if (((Entry)value).type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(((Entry)value).type)));
            }
            if (((Entry)value).display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(((Entry)value).display)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private T value;
    private boolean primary;
    private String type;
    private String display;

    public Entry(T value, String type) {
        this(value, type, false);
    }

    public Entry(T value, String type, boolean primary) {
        this.value = value;
        this.type = type;
        this.primary = primary;
    }

    public Entry(T value, String type, boolean primary, String display) {
        this.value = value;
        this.type = type;
        this.primary = primary;
        this.display = display;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        if (this.primary != entry.primary) {
            return false;
        }
        if (this.type != null ? !this.type.equals(entry.type) : entry.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(entry.value) : entry.value != null) {
            return false;
        }
        return !(this.display != null ? !this.display.equals(entry.display) : entry.display != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.primary ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Entry{value=" + this.value + ", type='" + this.type + '\'' + ", primary=" + this.primary + ", display=" + this.display + '}';
    }
}

