/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    protected <R extends BaseResource> R unmarshal(JSONObject jsonObject, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory, JSONArray defaultSchemas) throws JSONException, InvalidResourceException {
        try {
            SCIMObject scimObject = new SCIMObject();
            JSONArray schemas = jsonObject.has("schemas") ? jsonObject.getJSONArray("schemas") : defaultSchemas;
            for (AttributeDescriptor attributeDescriptor : resourceDescriptor.getAttributes()) {
                String externalAttributeName = attributeDescriptor.getName();
                Object jsonAttribute = jsonObject.opt(externalAttributeName);
                if (jsonAttribute == null) continue;
                scimObject.addAttribute(this.create(attributeDescriptor, jsonAttribute));
            }
            if (schemas != null) {
                for (int i = 0; i < schemas.length(); ++i) {
                    JSONObject schemaAttrs;
                    String schema = schemas.getString(i);
                    if (schema.equalsIgnoreCase("urn:scim:schemas:core:1.0") || (schemaAttrs = jsonObject.optJSONObject(schema)) == null || !resourceDescriptor.getAttributeSchemas().contains(schema)) continue;
                    Iterator keys = schemaAttrs.keys();
                    while (keys.hasNext()) {
                        String attributeName = (String)keys.next();
                        AttributeDescriptor attributeDescriptor = resourceDescriptor.getAttribute(schema, attributeName);
                        Object jsonAttribute = schemaAttrs.get(attributeName);
                        scimObject.addAttribute(this.create(attributeDescriptor, jsonAttribute));
                    }
                }
            }
            return resourceFactory.createResource(resourceDescriptor, scimObject);
        }
        catch (Exception e) {
            throw new InvalidResourceException("Resource '" + resourceDescriptor.getName() + "' is malformed: " + e.getMessage());
        }
    }

    protected SCIMAttribute createSimpleAttribute(Object jsonAttribute, AttributeDescriptor attributeDescriptor) {
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), jsonAttribute.toString()));
    }

    protected SCIMAttribute createMutiValuedAttribute(JSONArray jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>(jsonAttribute.length());
        for (int i = 0; i < jsonAttribute.length(); ++i) {
            SCIMAttributeValue value;
            Object o = jsonAttribute.get(i);
            if (o instanceof JSONObject) {
                value = this.createComplexAttribute((JSONObject)o, attributeDescriptor);
            } else {
                SCIMAttribute subAttr = SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), o.toString()));
                value = SCIMAttributeValue.createComplexValue(subAttr);
            }
            values.add(value);
        }
        SCIMAttributeValue[] vals = new SCIMAttributeValue[values.size()];
        vals = values.toArray(vals);
        return SCIMAttribute.create(attributeDescriptor, vals);
    }

    protected SCIMAttributeValue createComplexAttribute(JSONObject jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        Iterator keys = jsonAttribute.keys();
        ArrayList<SCIMAttribute> complexAttrs = new ArrayList<SCIMAttribute>(jsonAttribute.length());
        while (keys.hasNext()) {
            SCIMAttribute childAttr;
            Object o;
            String key = (String)keys.next();
            AttributeDescriptor subAttribute = attributeDescriptor.getSubAttribute(key);
            if (subAttribute == null) continue;
            if (subAttribute.isMultiValued()) {
                o = jsonAttribute.getJSONArray(key);
                childAttr = this.createMutiValuedAttribute((JSONArray)o, subAttribute);
            } else {
                o = jsonAttribute.get(key);
                childAttr = this.createSimpleAttribute(o, subAttribute);
            }
            complexAttrs.add(childAttr);
        }
        return SCIMAttributeValue.createComplexValue(complexAttrs);
    }

    protected SCIMAttribute create(AttributeDescriptor descriptor, Object jsonAttribute) throws JSONException, InvalidResourceException {
        if (descriptor.isMultiValued()) {
            if (!(jsonAttribute instanceof JSONArray)) {
                throw new InvalidResourceException("JSON array expected for multi-valued attribute '" + descriptor.getName() + "'");
            }
            return this.createMutiValuedAttribute((JSONArray)jsonAttribute, descriptor);
        }
        if (descriptor.getDataType() == AttributeDescriptor.DataType.COMPLEX) {
            if (!(jsonAttribute instanceof JSONObject)) {
                throw new InvalidResourceException("JSON object expected for multi-valued attribute '" + descriptor.getName() + "'");
            }
            return SCIMAttribute.create(descriptor, this.createComplexAttribute((JSONObject)jsonAttribute, descriptor));
        }
        return this.createSimpleAttribute(jsonAttribute, descriptor);
    }
}

