/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.xml;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.BulkInputStreamWrapper;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.Status;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlBulkParser {
    private final BulkInputStreamWrapper bulkInputStream;
    private final BulkConfig bulkConfig;
    private final BulkContentHandler handler;
    private XMLStreamReader xmlStreamReader;
    private int operationIndex = 0;
    private String defaultNamespaceURI;
    private boolean skipOperations;

    public XmlBulkParser(InputStream inputStream, BulkConfig bulkConfig, BulkContentHandler handler) {
        this.bulkInputStream = new BulkInputStreamWrapper(inputStream);
        this.bulkConfig = bulkConfig;
        this.handler = handler;
        this.operationIndex = 0;
        this.defaultNamespaceURI = null;
    }

    public void setSkipOperations(boolean skipOperations) {
        this.skipOperations = skipOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarshal() throws SCIMException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            this.xmlStreamReader = xmlInputFactory.createXMLStreamReader(this.bulkInputStream, "UTF-8");
            try {
                this.xmlStreamReader.require(7, null, null);
                while (this.xmlStreamReader.hasNext()) {
                    switch (this.xmlStreamReader.next()) {
                        case 1: {
                            if (this.xmlStreamReader.getLocalName().equals("Bulk")) {
                                if (this.xmlStreamReader.getNamespaceURI() != null) {
                                    this.defaultNamespaceURI = this.xmlStreamReader.getNamespaceURI();
                                }
                                if (this.parseBulk()) break;
                                return;
                            }
                            this.skipElement();
                        }
                    }
                }
            }
            finally {
                this.xmlStreamReader.close();
            }
        }
        catch (SCIMException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new InvalidResourceException("Error reading XML Bulk operation: " + e.getMessage(), e);
        }
    }

    private boolean parseBulk() throws XMLStreamException, SCIMException {
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (this.xmlStreamReader.getLocalName().equals("failOnErrors")) {
                        this.handler.handleFailOnErrors(Integer.parseInt(this.xmlStreamReader.getElementText()));
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("Operations")) {
                        if (this.parseOperations()) break;
                        return false;
                    }
                    this.skipElement();
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return true;
    }

    private boolean parseOperations() throws XMLStreamException, SCIMException {
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (this.xmlStreamReader.getLocalName().equals("Operation")) {
                        if ((long)this.operationIndex >= this.bulkConfig.getMaxOperations()) {
                            throw SCIMException.createException(413, "The number of operations in the bulk operation exceeds maxOperations (" + this.bulkConfig.getMaxOperations() + ")");
                        }
                        if (this.bulkInputStream.getBytesRead() > this.bulkConfig.getMaxPayloadSize()) {
                            throw SCIMException.createException(413, "The size of the bulk operation exceeds the maxPayloadSize (" + this.bulkConfig.getMaxPayloadSize() + ")");
                        }
                        if (this.skipOperations) {
                            this.skipElement();
                        } else if (!this.parseOperation()) {
                            return false;
                        }
                        ++this.operationIndex;
                        break;
                    }
                    this.skipElement();
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOperation() throws XMLStreamException, SCIMException {
        BulkOperation.Method method = null;
        String bulkId = null;
        String version = null;
        String path = null;
        String location = null;
        BaseResource resource = null;
        Status status = null;
        String endpoint = null;
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (this.xmlStreamReader.getLocalName().equals("method")) {
                        String httpMethod = this.xmlStreamReader.getElementText();
                        try {
                            method = BulkOperation.Method.valueOf(httpMethod);
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw SCIMException.createException(405, "Bulk operation " + this.operationIndex + " specifies an " + "invalid HTTP method '" + httpMethod + "'. " + "Allowed methods are " + Arrays.asList(BulkOperation.Method.values()));
                        }
                    }
                    if (this.xmlStreamReader.getLocalName().equals("bulkId")) {
                        bulkId = this.xmlStreamReader.getElementText();
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("version")) {
                        version = this.xmlStreamReader.getElementText();
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("path")) {
                        int endPos;
                        int startPos;
                        path = this.xmlStreamReader.getElementText();
                        if (path.charAt(startPos = 0) == '/') {
                            ++startPos;
                        }
                        if ((endPos = path.indexOf(47, startPos)) == -1) {
                            endPos = path.length();
                        }
                        endpoint = path.substring(startPos, endPos);
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("location")) {
                        location = this.xmlStreamReader.getElementText();
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("data")) {
                        if (path == null) {
                            throw new InvalidResourceException("Bulk operation " + this.operationIndex + " has data but no " + "path");
                        }
                        ResourceDescriptor descriptor = this.handler.getResourceDescriptor(endpoint);
                        if (descriptor == null) {
                            throw new InvalidResourceException("Bulk operation " + this.operationIndex + " specifies an " + "unknown resource endpoint '" + endpoint + "'");
                        }
                        resource = this.parseData(descriptor, BaseResource.BASE_RESOURCE_FACTORY);
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("status")) {
                        status = this.parseStatus();
                        break;
                    }
                    this.skipElement();
                    break;
                }
                case 2: {
                    return this.handler.handleOperation(this.operationIndex, new BulkOperation(method, bulkId, version, path, location, resource, status));
                }
            }
        }
        return this.handler.handleOperation(this.operationIndex, new BulkOperation(method, bulkId, version, path, location, resource, status));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Status parseStatus() throws XMLStreamException, SCIMException {
        String code = null;
        String description = null;
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (this.xmlStreamReader.getLocalName().equals("code")) {
                        code = this.xmlStreamReader.getElementText();
                        break;
                    }
                    if (this.xmlStreamReader.getLocalName().equals("description")) {
                        description = this.xmlStreamReader.getElementText();
                        break;
                    }
                    this.skipElement();
                    break;
                }
                case 2: {
                    return new Status(code, description);
                }
            }
        }
        return new Status(code, description);
    }

    /*
     * Enabled aggressive block sorting
     */
    private BaseResource parseData(ResourceDescriptor descriptor, ResourceFactory resourceFactory) throws XMLStreamException, SCIMException {
        SCIMObject scimObject = new SCIMObject();
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    scimObject.addAttribute(this.parseAttribute(descriptor));
                    break;
                }
                case 2: {
                    return resourceFactory.createResource(descriptor, scimObject);
                }
            }
        }
        return resourceFactory.createResource(descriptor, scimObject);
    }

    private SCIMAttribute parseAttribute(ResourceDescriptor resourceDescriptor) throws XMLStreamException, SCIMException {
        AttributeDescriptor attributeDescriptor;
        String namespaceURI = this.xmlStreamReader.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = this.defaultNamespaceURI;
        }
        if ((attributeDescriptor = resourceDescriptor.getAttribute(namespaceURI, this.xmlStreamReader.getLocalName())).isMultiValued()) {
            return this.parseMultiValuedAttribute(attributeDescriptor);
        }
        if (attributeDescriptor.getDataType() == AttributeDescriptor.DataType.COMPLEX) {
            return SCIMAttribute.create(attributeDescriptor, this.parseComplexAttributeValue(attributeDescriptor));
        }
        return this.parseSimpleAttribute(attributeDescriptor);
    }

    private SCIMAttribute parseSimpleAttribute(AttributeDescriptor attributeDescriptor) throws XMLStreamException, SCIMException {
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), this.handler.transformValue(this.operationIndex, this.xmlStreamReader.getElementText())));
    }

    /*
     * Enabled aggressive block sorting
     */
    private SCIMAttribute parseMultiValuedAttribute(AttributeDescriptor attributeDescriptor) throws XMLStreamException, SCIMException {
        ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>();
        block4: while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (!this.xmlStreamReader.getLocalName().equals(attributeDescriptor.getMultiValuedChildName())) break;
                    values.add(this.parseComplexAttributeValue(attributeDescriptor));
                    break;
                }
                case 2: {
                    break block4;
                }
            }
        }
        SCIMAttributeValue[] vals = new SCIMAttributeValue[values.size()];
        return SCIMAttribute.create(attributeDescriptor, values.toArray(vals));
    }

    /*
     * Enabled aggressive block sorting
     */
    private SCIMAttributeValue parseComplexAttributeValue(AttributeDescriptor attributeDescriptor) throws XMLStreamException, SCIMException {
        ArrayList<SCIMAttribute> complexAttrs = new ArrayList<SCIMAttribute>();
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    if (this.xmlStreamReader.getNamespaceURI() != null && !this.xmlStreamReader.getNamespaceURI().equalsIgnoreCase(attributeDescriptor.getSchema())) {
                        throw new InvalidResourceException("Sub-attribute " + this.xmlStreamReader.getLocalName() + " does not use the same namespace as the containing complex " + "attribute " + attributeDescriptor.getName());
                    }
                    AttributeDescriptor subAttribute = attributeDescriptor.getSubAttribute(this.xmlStreamReader.getLocalName());
                    SCIMAttribute childAttr = subAttribute.isMultiValued() ? this.parseMultiValuedAttribute(subAttribute) : this.parseSimpleAttribute(subAttribute);
                    complexAttrs.add(childAttr);
                    break;
                }
                case 2: {
                    return SCIMAttributeValue.createComplexValue(complexAttrs);
                }
            }
        }
        return SCIMAttributeValue.createComplexValue(complexAttrs);
    }

    private void skipElement() throws XMLStreamException {
        int nesting = 1;
        while (this.xmlStreamReader.hasNext()) {
            switch (this.xmlStreamReader.next()) {
                case 1: {
                    ++nesting;
                    break;
                }
                case 2: {
                    if (--nesting != 0) break;
                    return;
                }
            }
        }
    }
}

