/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.xml;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.marshal.StreamMarshaller;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.ServerErrorException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlStreamMarshaller
implements StreamMarshaller {
    private static final String xsiURI = "http://www.w3.org/2001/XMLSchema-instance";
    private final OutputStream outputStream;
    private final XMLStreamWriter xmlStreamWriter;

    public XmlStreamMarshaller(OutputStream outputStream) throws SCIMException {
        this.outputStream = outputStream;
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot create XML marshaller: " + e.getMessage());
        }
    }

    @Override
    public void close() throws SCIMException {
        try {
            this.xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            Debug.debugException(e);
        }
    }

    @Override
    public void marshal(BaseResource resource) throws SCIMException {
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.setDefaultNamespace("urn:scim:schemas:core:1.0");
            String resourceSchemaURI = resource.getResourceDescriptor().getSchema();
            this.xmlStreamWriter.writeStartElement("scim", resource.getResourceDescriptor().getName(), resourceSchemaURI);
            this.marshal(resource, this.xmlStreamWriter, null);
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write resource: " + e.getMessage());
        }
    }

    @Override
    public void marshal(SCIMException response) throws SCIMException {
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.setPrefix("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.setPrefix("xsi", xsiURI);
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "Response");
            this.xmlStreamWriter.writeNamespace("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.writeNamespace("xsi", xsiURI);
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "Errors");
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "Error");
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "code");
            this.xmlStreamWriter.writeCharacters(String.valueOf(response.getStatusCode()));
            this.xmlStreamWriter.writeEndElement();
            String description = response.getMessage();
            if (description != null) {
                this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "description");
                this.xmlStreamWriter.writeCharacters(description);
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write error response: " + e.getMessage());
        }
    }

    @Override
    public void marshal(Resources<? extends BaseResource> response) throws SCIMException {
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.setPrefix("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.setPrefix("xsi", xsiURI);
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "Response");
            this.xmlStreamWriter.writeNamespace("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.writeNamespace("xsi", xsiURI);
            this.xmlStreamWriter.writeStartElement("totalResults");
            this.xmlStreamWriter.writeCharacters(Long.toString(response.getTotalResults()));
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeStartElement("itemsPerPage");
            this.xmlStreamWriter.writeCharacters(Integer.toString(response.getItemsPerPage()));
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeStartElement("startIndex");
            this.xmlStreamWriter.writeCharacters(Long.toString(response.getStartIndex()));
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeStartElement("Resources");
            for (BaseResource baseResource : response) {
                this.xmlStreamWriter.writeStartElement("Resource");
                this.marshal(baseResource, this.xmlStreamWriter, xsiURI);
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write resources: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkStart(int failOnErrors, Set<String> schemaURIs) throws SCIMException {
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.setPrefix("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.setPrefix("xsi", xsiURI);
            this.xmlStreamWriter.writeStartElement("urn:scim:schemas:core:1.0", "Bulk");
            this.xmlStreamWriter.writeNamespace("scim", "urn:scim:schemas:core:1.0");
            this.xmlStreamWriter.writeNamespace("xsi", xsiURI);
            if (failOnErrors >= 0) {
                this.xmlStreamWriter.writeStartElement("failOnErrors");
                this.xmlStreamWriter.writeCharacters(Integer.toString(failOnErrors));
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeStartElement("Operations");
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write start of bulk operations: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkOperation(BulkOperation o) throws SCIMException {
        try {
            this.xmlStreamWriter.writeStartElement("Operation");
            if (o.getMethod() != null) {
                this.xmlStreamWriter.writeStartElement("method");
                this.xmlStreamWriter.writeCharacters(o.getMethod().toString());
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getBulkId() != null) {
                this.xmlStreamWriter.writeStartElement("bulkId");
                this.xmlStreamWriter.writeCharacters(o.getBulkId());
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getVersion() != null) {
                this.xmlStreamWriter.writeStartElement("version");
                this.xmlStreamWriter.writeCharacters(o.getVersion());
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getPath() != null) {
                this.xmlStreamWriter.writeStartElement("path");
                this.xmlStreamWriter.writeCharacters(o.getPath());
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getLocation() != null) {
                this.xmlStreamWriter.writeStartElement("location");
                this.xmlStreamWriter.writeCharacters(o.getLocation());
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getData() != null) {
                this.xmlStreamWriter.writeStartElement("data");
                this.marshal(o.getData(), this.xmlStreamWriter, xsiURI);
                this.xmlStreamWriter.writeEndElement();
            }
            if (o.getStatus() != null) {
                this.xmlStreamWriter.writeStartElement("status");
                this.xmlStreamWriter.writeStartElement("code");
                this.xmlStreamWriter.writeCharacters(o.getStatus().getCode());
                this.xmlStreamWriter.writeEndElement();
                if (o.getStatus().getDescription() != null) {
                    this.xmlStreamWriter.writeStartElement("description");
                    this.xmlStreamWriter.writeCharacters(o.getStatus().getDescription());
                    this.xmlStreamWriter.writeEndElement();
                }
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write bulk operation: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkFinish() throws SCIMException {
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write end of bulk operations: " + e.getMessage());
        }
    }

    @Override
    public void bulkMarshal(int failOnErrors, List<BulkOperation> operations) throws SCIMException {
        this.writeBulkStart(failOnErrors, Collections.<String>emptySet());
        for (BulkOperation o : operations) {
            this.writeBulkOperation(o);
        }
        this.writeBulkFinish();
    }

    private void marshal(BaseResource resource, XMLStreamWriter xmlStreamWriter, String xsiURI) throws XMLStreamException {
        String resourceSchemaURI = resource.getResourceDescriptor().getSchema();
        int i = 1;
        for (String schemaURI : resource.getResourceDescriptor().getAttributeSchemas()) {
            String prefix;
            if (schemaURI.equalsIgnoreCase(resourceSchemaURI)) {
                prefix = "scim";
                xmlStreamWriter.setPrefix("scim", schemaURI);
                xmlStreamWriter.writeNamespace("scim", schemaURI);
                continue;
            }
            if (!resource.getScimObject().hasSchema(schemaURI)) continue;
            prefix = "ns" + String.valueOf(i++);
            xmlStreamWriter.setPrefix(prefix, schemaURI);
            xmlStreamWriter.writeNamespace(prefix, schemaURI);
        }
        if (xsiURI != null) {
            xmlStreamWriter.writeAttribute(xsiURI, "type", "scim:" + resource.getResourceDescriptor().getName());
        }
        for (AttributeDescriptor attributeDescriptor : resource.getResourceDescriptor().getAttributes()) {
            SCIMAttribute a = resource.getScimObject().getAttribute(attributeDescriptor.getSchema(), attributeDescriptor.getName());
            if (a == null) continue;
            if (a.getAttributeDescriptor().isMultiValued()) {
                this.writeMultiValuedAttribute(a, xmlStreamWriter);
                continue;
            }
            this.writeSingularAttribute(a, xmlStreamWriter);
        }
    }

    private void writeMultiValuedAttribute(SCIMAttribute scimAttribute, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        SCIMAttributeValue[] values = scimAttribute.getValues();
        this.writeStartElement(scimAttribute, xmlStreamWriter);
        for (SCIMAttributeValue value : values) {
            this.writeChildStartElement(scimAttribute, xmlStreamWriter);
            for (AttributeDescriptor descriptor : scimAttribute.getAttributeDescriptor().getSubAttributes()) {
                SCIMAttribute a = value.getAttribute(descriptor.getName());
                if (a == null) continue;
                if (a.getAttributeDescriptor().isMultiValued()) {
                    this.writeMultiValuedAttribute(a, xmlStreamWriter);
                    continue;
                }
                this.writeSingularAttribute(a, xmlStreamWriter);
            }
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
    }

    private void writeSingularAttribute(SCIMAttribute scimAttribute, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        AttributeDescriptor attributeDescriptor = scimAttribute.getAttributeDescriptor();
        this.writeStartElement(scimAttribute, xmlStreamWriter);
        SCIMAttributeValue val = scimAttribute.getValue();
        if (val.isComplex()) {
            for (AttributeDescriptor ad : attributeDescriptor.getSubAttributes()) {
                SCIMAttribute a = val.getAttribute(ad.getName());
                if (a == null) continue;
                this.writeSingularAttribute(a, xmlStreamWriter);
            }
        } else {
            String stringValue = scimAttribute.getValue().getStringValue();
            xmlStreamWriter.writeCharacters(stringValue);
        }
        xmlStreamWriter.writeEndElement();
    }

    private void writeStartElement(SCIMAttribute scimAttribute, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (scimAttribute.getSchema().equalsIgnoreCase("urn:scim:schemas:core:1.0")) {
            xmlStreamWriter.writeStartElement(scimAttribute.getName());
        } else {
            xmlStreamWriter.writeStartElement(scimAttribute.getSchema(), scimAttribute.getName());
        }
    }

    private void writeChildStartElement(SCIMAttribute scimAttribute, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (scimAttribute.getSchema().equalsIgnoreCase("urn:scim:schemas:core:1.0")) {
            xmlStreamWriter.writeStartElement(scimAttribute.getAttributeDescriptor().getMultiValuedChildName());
        } else {
            xmlStreamWriter.writeStartElement(scimAttribute.getSchema(), scimAttribute.getAttributeDescriptor().getMultiValuedChildName());
        }
    }
}

