/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.xml;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.xml.XmlBulkParser;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.ServerErrorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUnmarshaller
implements Unmarshaller {
    @Override
    public <R extends BaseResource> R unmarshal(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        Document doc;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            dbFactory.setIgnoringElementContentWhitespace(true);
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new InvalidResourceException("Error reading XML: " + e.getMessage(), e);
        }
        Element documentElement = doc.getDocumentElement();
        if (resourceDescriptor == null) {
            throw new RuntimeException("No resource descriptor found for " + documentElement.getLocalName());
        }
        String documentNamespaceURI = documentElement.getNamespaceURI();
        return this.unmarshal(documentNamespaceURI, documentElement.getChildNodes(), resourceDescriptor, resourceFactory);
    }

    private <R extends BaseResource> R unmarshal(String documentNamespaceURI, NodeList nodeList, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        SCIMObject scimObject = new SCIMObject();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            AttributeDescriptor attributeDescriptor;
            Node element = nodeList.item(i);
            if (element.getNodeType() != 1) continue;
            String namespaceURI = element.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = documentNamespaceURI;
            }
            SCIMAttribute attr = (attributeDescriptor = resourceDescriptor.getAttribute(namespaceURI, element.getLocalName())).isMultiValued() ? this.createMultiValuedAttribute(element, attributeDescriptor) : (attributeDescriptor.getDataType() == AttributeDescriptor.DataType.COMPLEX ? SCIMAttribute.create(attributeDescriptor, this.createComplexAttribute(element, attributeDescriptor)) : this.createSimpleAttribute(element, attributeDescriptor));
            scimObject.addAttribute(attr);
        }
        return resourceFactory.createResource(resourceDescriptor, scimObject);
    }

    @Override
    public <R extends BaseResource> Resources<R> unmarshalResources(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        Document doc;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            dbFactory.setIgnoringElementContentWhitespace(true);
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new InvalidResourceException("Error reading XML: " + e.getMessage(), e);
        }
        String documentNamespaceURI = doc.getDocumentElement().getNamespaceURI();
        NodeList nodeList = doc.getElementsByTagName("*");
        int totalResults = 0;
        int startIndex = 1;
        List objects = Collections.emptyList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node element = nodeList.item(i);
            if (element.getLocalName().equals("totalResults")) {
                totalResults = Integer.valueOf(element.getTextContent());
                continue;
            }
            if (element.getLocalName().equals("startIndex")) {
                startIndex = Integer.valueOf(element.getTextContent());
                continue;
            }
            if (!element.getLocalName().equals("Resources")) continue;
            NodeList resources = element.getChildNodes();
            objects = new ArrayList(resources.getLength());
            for (int j = 0; j < resources.getLength(); ++j) {
                Node resource = resources.item(j);
                if (!resource.getLocalName().equals("Resource")) continue;
                objects.add(this.unmarshal(documentNamespaceURI, resource.getChildNodes(), resourceDescriptor, resourceFactory));
            }
        }
        return new Resources(objects, totalResults, startIndex);
    }

    @Override
    public SCIMException unmarshalError(InputStream inputStream) throws InvalidResourceException {
        Document doc;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            dbFactory.setIgnoringElementContentWhitespace(true);
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new InvalidResourceException("Error reading XML: " + e.getMessage(), e);
        }
        NodeList nodeList = doc.getDocumentElement().getFirstChild().getChildNodes();
        if (nodeList.getLength() >= 1) {
            String code = null;
            String description = null;
            NodeList nodes = nodeList.item(0).getChildNodes();
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node attr = nodes.item(j);
                if (attr.getLocalName().equals("code")) {
                    code = attr.getTextContent();
                    continue;
                }
                if (!attr.getLocalName().equals("description")) continue;
                description = attr.getTextContent();
            }
            return SCIMException.createException(Integer.valueOf(code), description);
        }
        return null;
    }

    @Override
    public void bulkUnmarshal(InputStream inputStream, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        XmlBulkParser xmlBulkParser = new XmlBulkParser(inputStream, bulkConfig, handler);
        xmlBulkParser.unmarshal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkUnmarshal(File file, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        XmlBulkParser xmlBulkParser;
        BufferedInputStream bufferedInputStream;
        FileInputStream fileInputStream;
        BulkContentHandler preProcessHandler = new BulkContentHandler(){};
        try {
            fileInputStream = new FileInputStream(file);
            try {
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    xmlBulkParser = new XmlBulkParser(bufferedInputStream, bulkConfig, preProcessHandler);
                    xmlBulkParser.setSkipOperations(true);
                    xmlBulkParser.unmarshal();
                }
                finally {
                    bufferedInputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error pre-processing bulk request: " + e.getMessage());
        }
        try {
            fileInputStream = new FileInputStream(file);
            try {
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    xmlBulkParser = new XmlBulkParser(bufferedInputStream, bulkConfig, handler);
                    xmlBulkParser.unmarshal();
                }
                finally {
                    bufferedInputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error parsing bulk request: " + e.getMessage());
        }
    }

    private SCIMAttribute createSimpleAttribute(Node node, AttributeDescriptor attributeDescriptor) {
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), node.getTextContent()));
    }

    private SCIMAttribute createMultiValuedAttribute(Node node, AttributeDescriptor attributeDescriptor) throws InvalidResourceException {
        NodeList attributes = node.getChildNodes();
        ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 1 || !attribute.getLocalName().equals(attributeDescriptor.getMultiValuedChildName())) continue;
            values.add(this.createComplexAttribute(attribute, attributeDescriptor));
        }
        SCIMAttributeValue[] vals = new SCIMAttributeValue[values.size()];
        vals = values.toArray(vals);
        return SCIMAttribute.create(attributeDescriptor, vals);
    }

    private SCIMAttributeValue createComplexAttribute(Node node, AttributeDescriptor attributeDescriptor) throws InvalidResourceException {
        NodeList childNodes = node.getChildNodes();
        ArrayList<SCIMAttribute> complexAttrs = new ArrayList<SCIMAttribute>(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item1 = childNodes.item(i);
            if (item1.getNodeType() != 1) continue;
            if (item1.getNamespaceURI() != null && !item1.getNamespaceURI().equalsIgnoreCase(attributeDescriptor.getSchema())) {
                throw new InvalidResourceException("Sub-attribute " + item1.getNodeName() + " does not use the same namespace as the " + "containing complex attribute " + attributeDescriptor.getName());
            }
            AttributeDescriptor subAttribute = attributeDescriptor.getSubAttribute(item1.getLocalName());
            SCIMAttribute childAttr = subAttribute.isMultiValued() ? this.createMultiValuedAttribute(item1, subAttribute) : this.createSimpleAttribute(item1, subAttribute);
            complexAttrs.add(childAttr);
        }
        return SCIMAttributeValue.createComplexValue(complexAttrs);
    }
}

