/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributePath {
    private static final Pattern pattern = Pattern.compile("^((.+):)?([^.]+)(\\.(.+))?$");
    private final String attributeSchema;
    private final String attributeName;
    private final String subAttributeName;

    public AttributePath(String attributeSchema, String attributeName, String subAttributeName) {
        this.attributeSchema = attributeSchema;
        this.attributeName = attributeName;
        this.subAttributeName = subAttributeName;
    }

    public static AttributePath parse(String path) {
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches() || matcher.groupCount() != 5) {
            throw new IllegalArgumentException(String.format("'%s' does not match '[schema:]attr[.sub-attr]' format", path));
        }
        String attributeSchema = matcher.group(2);
        String attributeName = matcher.group(3);
        String subAttributeName = matcher.group(5);
        if (attributeSchema != null) {
            return new AttributePath(attributeSchema, attributeName, subAttributeName);
        }
        return new AttributePath("urn:scim:schemas:core:1.0", attributeName, subAttributeName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        if (!this.attributeSchema.equalsIgnoreCase("urn:scim:schemas:core:1.0")) {
            builder.append(this.attributeSchema);
            builder.append(':');
        }
        builder.append(this.attributeName);
        if (this.subAttributeName != null) {
            builder.append('.');
            builder.append(this.subAttributeName);
        }
    }

    public String getAttributeSchema() {
        return this.attributeSchema;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getSubAttributeName() {
        return this.subAttributeName;
    }
}

