/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.FilterParser;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilterType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMFilter {
    private final SCIMFilterType filterType;
    private final AttributePath filterAttribute;
    private final String filterValue;
    private final boolean quoteFilterValue;
    private final List<SCIMFilter> filterComponents;

    public SCIMFilter(SCIMFilterType filterType, AttributePath filterAttribute, String filterValue, boolean quoteFilterValue, List<SCIMFilter> filterComponents) {
        this.filterType = filterType;
        this.filterAttribute = filterAttribute;
        this.filterValue = filterValue;
        this.quoteFilterValue = quoteFilterValue;
        this.filterComponents = filterComponents;
    }

    public static SCIMFilter parse(String filterString) throws SCIMException {
        FilterParser parser = new FilterParser(filterString);
        return parser.parse();
    }

    public static SCIMFilter createAndFilter(List<SCIMFilter> filterComponents) {
        return new SCIMFilter(SCIMFilterType.AND, null, null, false, new ArrayList<SCIMFilter>(filterComponents));
    }

    public static SCIMFilter createOrFilter(List<SCIMFilter> filterComponents) {
        return new SCIMFilter(SCIMFilterType.OR, null, null, false, new ArrayList<SCIMFilter>(filterComponents));
    }

    public static SCIMFilter createEqualityFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.EQUALITY, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createContainsFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.CONTAINS, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createStartsWithFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.STARTS_WITH, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createPresenceFilter(AttributePath filterAttribute) {
        return new SCIMFilter(SCIMFilterType.PRESENCE, filterAttribute, null, true, null);
    }

    public static SCIMFilter createGreaterThanFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.GREATER_THAN, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createGreaterOrEqualFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.GREATER_OR_EQUAL, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createLessThanFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.LESS_THAN, filterAttribute, filterValue, true, null);
    }

    public static SCIMFilter createLessOrEqualFilter(AttributePath filterAttribute, String filterValue) {
        return new SCIMFilter(SCIMFilterType.LESS_OR_EQUAL, filterAttribute, filterValue, true, null);
    }

    public SCIMFilterType getFilterType() {
        return this.filterType;
    }

    public AttributePath getFilterAttribute() {
        return this.filterAttribute;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public boolean isQuoteFilterValue() {
        return this.quoteFilterValue;
    }

    public List<SCIMFilter> getFilterComponents() {
        return this.filterComponents;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        switch (this.filterType) {
            case AND: 
            case OR: {
                builder.append('(');
                for (int i = 0; i < this.filterComponents.size(); ++i) {
                    if (i != 0) {
                        builder.append(' ');
                        builder.append((Object)this.filterType);
                        builder.append(' ');
                    }
                    builder.append(this.filterComponents.get(i));
                }
                builder.append(')');
                break;
            }
            case EQUALITY: 
            case CONTAINS: 
            case STARTS_WITH: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                builder.append(this.filterAttribute);
                builder.append(' ');
                builder.append((Object)this.filterType);
                builder.append(' ');
                if (this.quoteFilterValue) {
                    try {
                        builder.append(JSONObject.valueToString((Object)this.filterValue));
                    }
                    catch (JSONException e) {
                        Debug.debugException(e);
                    }
                    break;
                }
                builder.append(this.filterValue);
                break;
            }
            case PRESENCE: {
                builder.append(this.filterAttribute);
                builder.append(' ');
                builder.append((Object)this.filterType);
            }
        }
    }
}

