/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk.examples;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Manager;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMService;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.MediaType;

public class ClientExample {
    public static final ResourceFactory<DeviceResource> DEVICE_RESOURCE_FACTORY = new ResourceFactory<DeviceResource>(){

        @Override
        public DeviceResource createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new DeviceResource(resourceDescriptor, scimObject);
        }
    };

    public static void main(String[] args) throws Exception {
        Manager manager;
        URI uri = URI.create("http://localhost:52959");
        SCIMService scimService = new SCIMService(uri, "uid=bjensen,dc=example,dc=com", "password");
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        SCIMEndpoint<UserResource> endpoint = scimService.getUserEndpoint();
        UserResource user = endpoint.get("uid=bjensen,dc=example,dc=com");
        Name name = user.getName();
        Collection<Entry<String>> phoneNumbers = user.getPhoneNumbers();
        if (phoneNumbers != null) {
            for (Entry<String> phoneNumber : phoneNumbers) {
                System.out.println(phoneNumber);
            }
        }
        if ((manager = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER)) == null) {
            manager = new Manager("uid=jsmith,dc=example,dc=com", "Manager John");
        }
        manager.setDisplayName("Best in the world");
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER, manager);
        String employeeNumber = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "employeeNumber", AttributeValueResolver.STRING_RESOLVER);
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "department", AttributeValueResolver.STRING_RESOLVER, "sales");
        user.setNickName("brad");
        endpoint.update(user);
        ResourceDescriptor deviceDescriptor = scimService.getResourceDescriptor("Device", null);
        SCIMEndpoint<DeviceResource> deviceEndpoint = scimService.getEndpoint(deviceDescriptor, DEVICE_RESOURCE_FACTORY);
    }

    public static class DeviceResource
    extends BaseResource {
        public DeviceResource(ResourceDescriptor resourceDescriptor) {
            super(resourceDescriptor);
        }

        public DeviceResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            super(resourceDescriptor, scimObject);
        }

        public String getVendorName() {
            return this.getSingularAttributeValue("urn:com:example:device:1.0", "vendorName", AttributeValueResolver.STRING_RESOLVER);
        }
    }
}

