/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkStreamResponse;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DebugType;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMResponse;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.sdk.UnauthorizedException;
import com.unboundid.scim.wink.BulkContentRequestHandler;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMApplication;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

public class AbstractBulkResource {
    private final SCIMApplication application;
    private final ResourceStats bulkResourceStats;
    private final SCIMBackend backend;

    public AbstractBulkResource(SCIMApplication application, ResourceStats bulkResourceStats, SCIMBackend backend) {
        this.application = application;
        this.bulkResourceStats = bulkResourceStats;
        this.backend = backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response postBulk(RequestContext requestContext, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        Unmarshaller unmarshaller;
        if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            unmarshaller = new JsonUnmarshaller();
            this.bulkResourceStats.incrementStat("post-content-json");
        } else {
            unmarshaller = new XmlUnmarshaller();
            this.bulkResourceStats.incrementStat("post-content-xml");
        }
        try {
            String authID = requestContext.getAuthID();
            if (authID == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            ServiceProviderConfig serviceProviderConfig = this.application.getServiceProviderConfig();
            BulkConfig bulkConfig = serviceProviderConfig.getBulkConfig();
            if (requestContext.getContentLength() > bulkConfig.getMaxPayloadSize()) {
                throw SCIMException.createException(413, "The content length of the bulk request (" + requestContext.getContentLength() + ") exceeds the maxPayloadSize (" + bulkConfig.getMaxPayloadSize() + ")");
            }
            this.application.acquireBulkRequestPermit();
            try {
                File requestFile = File.createTempFile("scim-bulk-request-", "." + requestContext.getConsumeMediaType().getSubtype(), this.application.getTmpDataDir());
                try {
                    requestFile.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(requestFile);
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[8192];
                        long totalBytes = 0L;
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            if ((totalBytes += (long)bytesRead) > bulkConfig.getMaxPayloadSize()) {
                                throw SCIMException.createException(413, "The size of the bulk request exceeds the maxPayloadSize (" + bulkConfig.getMaxPayloadSize() + ")");
                            }
                            fileOutputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        fileOutputStream.close();
                    }
                    BulkStreamResponse bulkStreamResponse = new BulkStreamResponse(this.application, requestContext);
                    try {
                        BulkContentRequestHandler handler = new BulkContentRequestHandler(this.application, requestContext, this.backend, bulkStreamResponse);
                        unmarshaller.bulkUnmarshal(requestFile, bulkConfig, (BulkContentHandler)handler);
                        responseBuilder = Response.status((Response.Status)Response.Status.OK);
                        this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), bulkStreamResponse);
                        this.bulkResourceStats.incrementStat("post-successful");
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        bulkStreamResponse.finalizeResponse();
                        throw e;
                    }
                }
                finally {
                    if (!requestFile.delete()) {
                        Debug.debug(Level.WARNING, DebugType.OTHER, "Could not delete temporary file " + requestFile.getAbsolutePath());
                    }
                }
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ServerErrorException("Error processing bulk request: " + e.getMessage());
            }
            finally {
                this.application.releaseBulkRequestPermit();
            }
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.bulkResourceStats.incrementStat("post-" + e.getStatusCode());
        }
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.bulkResourceStats.incrementStat("post-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.bulkResourceStats.incrementStat("post-response-xml");
        }
        return responseBuilder.build();
    }

    private void setResponseEntity(Response.ResponseBuilder builder, MediaType mediaType, final SCIMResponse scimResponse) {
        builder.type(mediaType);
        final Marshaller marshaller = mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonMarshaller() : new XmlMarshaller();
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    scimResponse.marshal(marshaller, outputStream);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
        };
        builder.entity((Object)output);
    }
}

