/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.BulkStreamResponse;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMQueryAttributes;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.sdk.Status;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMApplication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

public class BulkContentRequestHandler
extends BulkContentHandler {
    private final Map<String, ResourceDescriptor> descriptors;
    private final SCIMApplication application;
    private final RequestContext requestContext;
    private final SCIMBackend backend;
    private final BulkStreamResponse bulkStreamResponse;
    private final Map<String, String> resourceIDs;
    private final Set<String> unresolvedBulkIdRefs;
    private int errorCount = 0;
    private final Set<String> bulkIds;
    private int failOnErrors = Integer.MAX_VALUE;

    public BulkContentRequestHandler(SCIMApplication application, RequestContext requestContext, SCIMBackend backend, BulkStreamResponse bulkStreamResponse) {
        this.descriptors = application.getDescriptors();
        this.application = application;
        this.requestContext = requestContext;
        this.backend = backend;
        this.bulkStreamResponse = bulkStreamResponse;
        this.resourceIDs = new HashMap<String, String>();
        this.unresolvedBulkIdRefs = new HashSet<String>();
        this.bulkIds = new HashSet<String>();
    }

    public void handleFailOnErrors(int failOnErrors) {
        this.failOnErrors = failOnErrors;
    }

    public String transformValue(int opIndex, String value) {
        if (value.startsWith("bulkId:")) {
            String bulkId = value.substring(7);
            String resourceID = this.resourceIDs.get(bulkId);
            if (resourceID != null) {
                return resourceID;
            }
            this.unresolvedBulkIdRefs.add(bulkId);
        }
        return value;
    }

    public ResourceDescriptor getResourceDescriptor(String endpoint) {
        return this.descriptors.get(endpoint);
    }

    public boolean handleOperation(int opIndex, BulkOperation bulkOperation) throws SCIMException {
        if (this.errorCount < this.failOnErrors) {
            BulkOperation response = this.processOperation(opIndex, bulkOperation);
            this.unresolvedBulkIdRefs.clear();
            this.bulkStreamResponse.writeBulkOperation(response);
            if (response.getStatus().getDescription() != null && !response.getStatus().getCode().equals("200") && !response.getStatus().getCode().equals("201")) {
                ++this.errorCount;
                if (this.errorCount == this.failOnErrors) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private BulkOperation processOperation(int opIndex, BulkOperation operation) {
        ResourceStats resourceStats;
        ResourceDescriptor descriptor;
        BulkOperation.Method method = operation.getMethod();
        String bulkId = operation.getBulkId();
        String path = operation.getPath();
        BaseResource resource = operation.getData();
        int statusCode = 200;
        String statusMessage = null;
        String location = null;
        String endpoint = null;
        String resourceID = null;
        try {
            if (method == null) {
                throw new InvalidResourceException("The bulk operation does not specify a HTTP method");
            }
            if (method == BulkOperation.Method.PATCH) {
                throw SCIMException.createException(501, "PATCH is not supported");
            }
            if (path == null) {
                throw new InvalidResourceException("The bulk operation does not specify a path");
            }
            if (path != null) {
                int endPos;
                int startPos = 0;
                if (path.charAt(startPos) == '/') {
                    ++startPos;
                }
                if ((endPos = path.indexOf(47, startPos)) == -1) {
                    endPos = path.length();
                }
                endpoint = path.substring(startPos, endPos);
                if (endPos < path.length() - 1) {
                    resourceID = path.substring(endPos + 1);
                }
                if (method == BulkOperation.Method.POST) {
                    if (resourceID != null) {
                        throw new InvalidResourceException("The bulk operation has method POST but the path includesa resource ID");
                    }
                } else {
                    String ref;
                    if (resourceID == null) {
                        throw new InvalidResourceException("The bulk operation does not have a resource ID in the path");
                    }
                    if (resourceID.startsWith("bulkId:") && (resourceID = this.resourceIDs.get(ref = resourceID.substring(7))) == null) {
                        throw SCIMException.createException(409, "Cannot resolve bulkId reference '" + ref + "'");
                    }
                }
            }
            if ((descriptor = this.getResourceDescriptor(endpoint)) == null) {
                throw new InvalidResourceException("The bulk operation specifies an unknown resource endpoint '" + endpoint + "'");
            }
            resourceStats = this.application.getStatsForResource(descriptor.getName());
            if (resourceStats == null) {
                throw new ServerErrorException("Cannot find resource stats for resource '" + descriptor.getName() + "'");
            }
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            statusCode = e.getStatusCode();
            statusMessage = e.getMessage();
            Status status = new Status(String.valueOf(statusCode), statusMessage);
            return new BulkOperation(method, bulkId, null, null, location, null, status);
        }
        try {
            UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.requestContext.getUriInfo().getBaseUri());
            locationBuilder.path(path);
            if (method == BulkOperation.Method.POST && bulkId == null) {
                throw new InvalidResourceException("The bulk operation has method POST but does not specify a bulkId");
            }
            if (bulkId != null && !this.bulkIds.add(bulkId)) {
                throw new InvalidResourceException("The bulk operation defines a duplicate bulkId '" + bulkId + "'");
            }
            if (method != BulkOperation.Method.DELETE && resource == null) {
                throw new InvalidResourceException("The bulk operation does not have any resource data");
            }
            if (!this.unresolvedBulkIdRefs.isEmpty()) {
                throw SCIMException.createException(409, "Cannot resolve bulkId references " + this.unresolvedBulkIdRefs);
            }
            if (this.requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                switch (method) {
                    case POST: {
                        resourceStats.incrementStat("post-content-json");
                        break;
                    }
                    case PUT: {
                        resourceStats.incrementStat("put-content-json");
                    }
                }
            } else {
                switch (method) {
                    case POST: {
                        resourceStats.incrementStat("post-content-xml");
                        break;
                    }
                    case PUT: {
                        resourceStats.incrementStat("put-content-xml");
                    }
                }
            }
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(descriptor, "");
            switch (method) {
                case POST: {
                    BaseResource postedResource = this.backend.postResource(new PostResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resource.getScimObject(), queryAttributes));
                    resourceID = postedResource.getId();
                    locationBuilder.path(resourceID);
                    location = locationBuilder.build(new Object[0]).toString();
                    statusCode = 201;
                    resourceStats.incrementStat("post-successful");
                    break;
                }
                case PUT: {
                    this.backend.putResource(new PutResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resourceID, resource.getScimObject(), queryAttributes));
                    location = locationBuilder.build(new Object[0]).toString();
                    resourceStats.incrementStat("put-successful");
                    break;
                }
                case DELETE: {
                    this.backend.deleteResource(new DeleteResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resourceID));
                    location = locationBuilder.build(new Object[0]).toString();
                    resourceStats.incrementStat("delete-successful");
                }
            }
            if (bulkId != null) {
                this.resourceIDs.put(bulkId, resourceID);
            }
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            statusCode = e.getStatusCode();
            statusMessage = e.getMessage();
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-" + e.getStatusCode());
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-" + e.getStatusCode());
                    break;
                }
                case DELETE: {
                    resourceStats.incrementStat("delete-" + e.getStatusCode());
                }
            }
        }
        if (this.requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-response-json");
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-response-json");
                }
            }
        } else if (this.requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-response-xml");
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-response-xml");
                }
            }
        }
        Status status = new Status(String.valueOf(statusCode), statusMessage);
        return new BulkOperation(method, bulkId, null, null, location, null, status);
    }

    private BaseResource resolveBulkIds(BaseResource resource) throws SCIMException {
        SCIMObject src = resource.getScimObject();
        SCIMObject dst = new SCIMObject();
        for (String schema : src.getSchemas()) {
            for (SCIMAttribute a : src.getAttributes(schema)) {
                dst.setAttribute(this.resolveBulkIds(a));
            }
        }
        return new BaseResource(resource.getResourceDescriptor(), dst);
    }

    private SCIMAttribute resolveBulkIds(SCIMAttribute a) throws SCIMException {
        SCIMAttributeValue[] srcValues = a.getValues();
        SCIMAttributeValue[] dstValues = new SCIMAttributeValue[a.getValues().length];
        for (int i = 0; i < srcValues.length; ++i) {
            dstValues[i] = this.resolveBulkIds(srcValues[i]);
        }
        return SCIMAttribute.create(a.getAttributeDescriptor(), dstValues);
    }

    private SCIMAttributeValue resolveBulkIds(SCIMAttributeValue v) throws SCIMException {
        if (v.isComplex()) {
            Collection<SCIMAttribute> srcAttrs = v.getAttributes().values();
            ArrayList<SCIMAttribute> dstAttrs = new ArrayList<SCIMAttribute>(srcAttrs.size());
            for (SCIMAttribute a : srcAttrs) {
                dstAttrs.add(this.resolveBulkIds(a));
            }
            return SCIMAttributeValue.createComplexValue(dstAttrs);
        }
        String s = v.getStringValue();
        if (s.startsWith("bulkId:")) {
            String bulkId = s.substring(7);
            String resourceID = this.resourceIDs.get(bulkId);
            if (resourceID != null) {
                return SCIMAttributeValue.createStringValue(resourceID);
            }
            throw SCIMException.createException(409, "Cannot resolve bulkId reference '" + bulkId + "'");
        }
        return v;
    }
}

