/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import java.security.Principal;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

public class RequestContext {
    private final ServletContext servletContext;
    private final SecurityContext securityContext;
    private final HttpHeaders headers;
    private final UriInfo uriInfo;
    private final String authID;
    private final String origin;
    private final MediaType consumeMediaType;
    private final MediaType produceMediaType;
    private final long contentLength;

    public RequestContext(ServletContext servletContext, SecurityContext securityContext, HttpHeaders headers, UriInfo uriInfo, MediaType consumeMediaType, MediaType produceMediaType) {
        this.servletContext = servletContext;
        this.securityContext = securityContext;
        this.headers = headers;
        this.uriInfo = uriInfo;
        this.consumeMediaType = consumeMediaType;
        this.produceMediaType = produceMediaType;
        Principal userPrincipal = securityContext.getUserPrincipal();
        this.authID = userPrincipal != null ? userPrincipal.getName() : null;
        List originHeaders = headers.getRequestHeader("Origin");
        this.origin = originHeaders != null ? (String)originHeaders.get(0) : null;
        List contentLengthHeaders = headers.getRequestHeader("Content-Length");
        this.contentLength = contentLengthHeaders != null ? Long.parseLong((String)contentLengthHeaders.get(0)) : -1L;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public String getAuthID() {
        return this.authID;
    }

    public String getOrigin() {
        return this.origin;
    }

    public MediaType getConsumeMediaType() {
        return this.consumeMediaType;
    }

    public MediaType getProduceMediaType() {
        return this.produceMediaType;
    }

    public long getContentLength() {
        return this.contentLength;
    }
}

