/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.AuthenticationScheme;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ChangePasswordConfig;
import com.unboundid.scim.data.ETagConfig;
import com.unboundid.scim.data.FilterConfig;
import com.unboundid.scim.data.PatchConfig;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.data.SortConfig;
import com.unboundid.scim.data.XmlDataFormatConfig;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.ResourceSchemaBackend;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.wink.AdjustableSemaphore;
import com.unboundid.scim.wink.BulkResource;
import com.unboundid.scim.wink.JSONBulkResource;
import com.unboundid.scim.wink.JSONQueryResource;
import com.unboundid.scim.wink.JSONServiceProviderConfigResource;
import com.unboundid.scim.wink.MonitorResource;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMResource;
import com.unboundid.scim.wink.ServiceProviderConfigResource;
import com.unboundid.scim.wink.XMLBulkResource;
import com.unboundid.scim.wink.XMLQueryResource;
import com.unboundid.scim.wink.XMLServiceProviderConfigResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.wink.common.WinkApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMApplication
extends WinkApplication {
    private final Set<Object> instances;
    private final Map<String, ResourceDescriptor> descriptors;
    private final Map<String, ResourceStats> resourceStats;
    private final SCIMBackend backend;
    private volatile long bulkMaxOperations = Long.MAX_VALUE;
    private volatile long bulkMaxPayloadSize = Long.MAX_VALUE;
    private volatile File tmpDataDir = null;
    private AdjustableSemaphore bulkMaxConcurrentRequestsSemaphore = new AdjustableSemaphore(Integer.MAX_VALUE);

    public SCIMApplication(Collection<ResourceDescriptor> resourceDescriptors, SCIMBackend backend) {
        this.descriptors = new HashMap<String, ResourceDescriptor>(resourceDescriptors.size());
        for (ResourceDescriptor descriptor : resourceDescriptors) {
            this.descriptors.put(descriptor.getEndpoint(), descriptor);
        }
        this.instances = new HashSet<Object>(resourceDescriptors.size() * 4 + 12);
        ArrayList<ResourceStats> statsCollection = new ArrayList<ResourceStats>(resourceDescriptors.size() + 2);
        ResourceStats stats = new ResourceStats("monitor");
        this.instances.add(new MonitorResource(this, stats));
        statsCollection.add(stats);
        stats = new ResourceStats(CoreSchema.SERVICE_PROVIDER_CONFIG_SCHEMA_DESCRIPTOR.getName());
        this.instances.add(new ServiceProviderConfigResource(this, stats));
        this.instances.add(new XMLServiceProviderConfigResource(this, stats));
        this.instances.add(new JSONServiceProviderConfigResource(this, stats));
        statsCollection.add(stats);
        stats = new ResourceStats(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR.getName());
        ResourceSchemaBackend resourceSchemaBackend = new ResourceSchemaBackend(resourceDescriptors);
        this.instances.add((Object)new SCIMResource(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR, stats, resourceSchemaBackend));
        this.instances.add((Object)new XMLQueryResource(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR, stats, resourceSchemaBackend));
        this.instances.add((Object)new JSONQueryResource(CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR, stats, resourceSchemaBackend));
        statsCollection.add(stats);
        for (ResourceDescriptor resourceDescriptor : resourceDescriptors) {
            stats = new ResourceStats(resourceDescriptor.getName());
            this.instances.add((Object)new SCIMResource(resourceDescriptor, stats, backend));
            this.instances.add((Object)new XMLQueryResource(resourceDescriptor, stats, backend));
            this.instances.add((Object)new JSONQueryResource(resourceDescriptor, stats, backend));
            statsCollection.add(stats);
        }
        stats = new ResourceStats("Bulk");
        this.instances.add(new BulkResource(this, stats, backend));
        this.instances.add(new JSONBulkResource(this, stats, backend));
        this.instances.add(new XMLBulkResource(this, stats, backend));
        statsCollection.add(stats);
        this.resourceStats = new HashMap<String, ResourceStats>(statsCollection.size());
        for (ResourceStats s : statsCollection) {
            this.resourceStats.put(s.getName(), s);
        }
        this.backend = backend;
    }

    public Set<Object> getInstances() {
        return this.instances;
    }

    public Collection<ResourceStats> getResourceStats() {
        return Collections.unmodifiableCollection(this.resourceStats.values());
    }

    public ResourceStats getStatsForResource(String resourceName) {
        return this.resourceStats.get(resourceName);
    }

    public ServiceProviderConfig getServiceProviderConfig() {
        SCIMObject scimObject = new SCIMObject();
        ServiceProviderConfig serviceProviderConfig = ServiceProviderConfig.SERVICE_PROVIDER_CONFIG_RESOURCE_FACTORY.createResource(CoreSchema.SERVICE_PROVIDER_CONFIG_SCHEMA_DESCRIPTOR, scimObject);
        serviceProviderConfig.setId("urn:scim:schemas:core:1.0");
        serviceProviderConfig.setPatchConfig(new PatchConfig(false));
        serviceProviderConfig.setBulkConfig(new BulkConfig(true, this.bulkMaxOperations, this.bulkMaxPayloadSize));
        serviceProviderConfig.setFilterConfig(new FilterConfig(true, this.backend.getConfig().getMaxResults()));
        serviceProviderConfig.setChangePasswordConfig(new ChangePasswordConfig(false));
        serviceProviderConfig.setSortConfig(new SortConfig(false));
        serviceProviderConfig.setETagConfig(new ETagConfig(false));
        ArrayList<AuthenticationScheme> authenticationSchemes = new ArrayList<AuthenticationScheme>();
        authenticationSchemes.add(new AuthenticationScheme("HttpBasic", "The HTTP Basic Access Authentication scheme. This scheme is not considered to be a secure method of user authentication (unless used in conjunction with some external secure system such as SSL), as the user name and password are passed over the network as cleartext.", "http://www.ietf.org/rfc/rfc2617.txt", "http://en.wikipedia.org/wiki/Basic_access_authentication", null, false));
        serviceProviderConfig.setAuthenticationSchemes(authenticationSchemes);
        serviceProviderConfig.setXmlDataFormatConfig(new XmlDataFormatConfig(true));
        return serviceProviderConfig;
    }

    public void setBulkMaxOperations(long bulkMaxOperations) {
        this.bulkMaxOperations = bulkMaxOperations;
    }

    public void setBulkMaxPayloadSize(long bulkMaxPayloadSize) {
        this.bulkMaxPayloadSize = bulkMaxPayloadSize;
    }

    public void setBulkMaxConcurrentRequests(int bulkMaxConcurrentRequests) {
        this.bulkMaxConcurrentRequestsSemaphore.setMaxPermits(bulkMaxConcurrentRequests);
    }

    public Map<String, ResourceDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public File getTmpDataDir() {
        return this.tmpDataDir;
    }

    public void setTmpDataDir(File tmpDataDir) {
        this.tmpDataDir = tmpDataDir;
    }

    public void acquireBulkRequestPermit() throws SCIMException {
        if (!this.bulkMaxConcurrentRequestsSemaphore.tryAcquire()) {
            throw SCIMException.createException(503, "The server is currently processing the maximum number of concurrent bulk requests (" + this.bulkMaxConcurrentRequestsSemaphore.getMaxPermits() + ")");
        }
    }

    public void releaseBulkRequestPermit() {
        this.bulkMaxConcurrentRequestsSemaphore.release();
    }
}

