/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.wink.AbstractSCIMResource;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.ResourceStats;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

public class SCIMResource
extends AbstractSCIMResource {
    public SCIMResource(ResourceDescriptor resourceDescriptor, ResourceStats resourceStats, SCIMBackend backend) {
        super(resourceDescriptor.getEndpoint(), resourceDescriptor, resourceStats, backend);
    }

    @GET
    @Produces(value={"application/json"})
    public Response doJsonGet(@Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="filter") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortOrder") String sortOrder, @QueryParam(value="startIndex") String pageStartIndex, @QueryParam(value="count") String pageSize) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.getUsers(requestContext, filterString, sortBy, sortOrder, pageStartIndex, pageSize);
    }

    @GET
    @Produces(value={"application/xml"})
    public Response doXmlGet(@Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="filter") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortOrder") String sortOrder, @QueryParam(value="startIndex") String pageStartIndex, @QueryParam(value="count") String pageSize) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.getUsers(requestContext, filterString, sortBy, sortOrder, pageStartIndex, pageSize);
    }

    @GET
    @Path(value="{userID}")
    @Produces(value={"application/json"})
    public Response doJsonGet(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.getUser(requestContext, userID);
    }

    @GET
    @Path(value="{userID}")
    @Produces(value={"application/xml"})
    public Response doXmlGet(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.getUser(requestContext, userID);
    }

    @GET
    @Path(value="{userID}.json")
    @Produces(value={"application/json"})
    public Response doDotJsonGet(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.getUser(requestContext, userID);
    }

    @GET
    @Path(value="{userID}.xml")
    @Produces(value={"application/xml"})
    public Response doDotXmlGet(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.getUser(requestContext, userID);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doJsonJsonPost(InputStream inputStream, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.postUser(requestContext, inputStream);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response doXmlXmlPost(InputStream inputStream, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.postUser(requestContext, inputStream);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response doXmlJsonPost(InputStream inputStream, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.postUser(requestContext, inputStream);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public Response doJsonXmlPost(InputStream inputStream, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.postUser(requestContext, inputStream);
    }

    @PUT
    @Path(value="{userID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doJsonJsonPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @PUT
    @Path(value="{userID}.json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doDotJsonPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @PUT
    @Path(value="{userID}.xml")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response doDotXmlPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @PUT
    @Path(value="{userID}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response doXmlXmlPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @PUT
    @Path(value="{userID}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response doXmlJsonPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @PUT
    @Path(value="{userID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public Response doJsonXmlPut(InputStream inputStream, @PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.putUser(requestContext, userID, inputStream);
    }

    @DELETE
    @Path(value="{userID}")
    @Produces(value={"application/json"})
    public Response doJsonDelete(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.deleteUser(requestContext, userID);
    }

    @DELETE
    @Path(value="{userID}")
    @Produces(value={"application/xml"})
    public Response doXmlDelete(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.deleteUser(requestContext, userID);
    }

    @DELETE
    @Path(value="{userID}.json")
    @Produces(value={"application/json"})
    public Response doDotJsonDelete(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        return this.deleteUser(requestContext, userID);
    }

    @DELETE
    @Path(value="{userID}.xml")
    @Produces(value={"application/xml"})
    public Response doDotXmlDelete(@PathParam(value="userID") String userID, @Context ServletContext servletContext, @Context SecurityContext securityContext, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        RequestContext requestContext = new RequestContext(servletContext, securityContext, headers, uriInfo, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
        return this.deleteUser(requestContext, userID);
    }
}

