/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    protected <R extends BaseResource> R unmarshal(JSONObject jsonObject, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory, JSONArray defaultSchemas) throws JSONException, InvalidResourceException {
        try {
            JSONArray schemas;
            SCIMObject scimObject = new SCIMObject();
            if (jsonObject.has("schemas")) {
                schemas = jsonObject.getJSONArray("schemas");
            } else if (defaultSchemas != null) {
                schemas = defaultSchemas;
            } else {
                String[] schemaArray = new String[]{resourceDescriptor.getSchema()};
                schemas = new JSONArray((Object)schemaArray);
            }
            boolean singleSchema = schemas.length() == 1;
            for (int i = 0; i < schemas.length(); ++i) {
                Object jsonAttribute;
                AttributeDescriptor attributeDescriptor;
                String attributeName;
                Iterator keys;
                JSONObject schemaAttrs;
                String schema = StaticUtils.toLowerCase(schemas.getString(i));
                if (singleSchema) {
                    schemaAttrs = jsonObject.optJSONObject(schema);
                    if (schemaAttrs != null) {
                        --i;
                        singleSchema = false;
                        continue;
                    }
                    keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        attributeName = (String)keys.next();
                        if ("schemas".equals(attributeName)) continue;
                        attributeDescriptor = resourceDescriptor.getAttribute(schema, attributeName);
                        jsonAttribute = jsonObject.get(attributeName);
                        scimObject.addAttribute(this.create(attributeDescriptor, jsonAttribute));
                    }
                    continue;
                }
                schemaAttrs = jsonObject.optJSONObject(schema);
                if (schemaAttrs != null) {
                    if (!resourceDescriptor.getAttributeSchemas().contains(schema)) continue;
                    keys = schemaAttrs.keys();
                    while (keys.hasNext()) {
                        attributeName = (String)keys.next();
                        attributeDescriptor = resourceDescriptor.getAttribute(schema, attributeName);
                        jsonAttribute = schemaAttrs.get(attributeName);
                        scimObject.addAttribute(this.create(attributeDescriptor, jsonAttribute));
                    }
                    continue;
                }
                if (!"urn:scim:schemas:core:1.0".equals(schema)) continue;
                for (AttributeDescriptor attributeDescriptor2 : resourceDescriptor.getAttributes(schema)) {
                    Object jsonAttribute2 = jsonObject.opt(StaticUtils.toLowerCase(attributeDescriptor2.getName()));
                    if (jsonAttribute2 == null) continue;
                    scimObject.addAttribute(this.create(attributeDescriptor2, jsonAttribute2));
                }
            }
            return resourceFactory.createResource(resourceDescriptor, scimObject);
        }
        catch (Exception e) {
            throw new InvalidResourceException("Resource '" + resourceDescriptor.getName() + "' is malformed: " + e.getMessage());
        }
    }

    protected SCIMAttribute createSimpleAttribute(Object jsonAttribute, AttributeDescriptor attributeDescriptor) {
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), jsonAttribute.toString()));
    }

    protected SCIMAttribute createMutiValuedAttribute(JSONArray jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>(jsonAttribute.length());
        for (int i = 0; i < jsonAttribute.length(); ++i) {
            SCIMAttributeValue value;
            Object o = jsonAttribute.get(i);
            if (o instanceof JSONObject) {
                value = this.createComplexAttribute((JSONObject)o, attributeDescriptor);
            } else {
                SCIMAttribute subAttr = SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), o.toString()));
                value = SCIMAttributeValue.createComplexValue(subAttr);
            }
            values.add(value);
        }
        SCIMAttributeValue[] vals = new SCIMAttributeValue[values.size()];
        vals = values.toArray(vals);
        return SCIMAttribute.create(attributeDescriptor, vals);
    }

    protected SCIMAttributeValue createComplexAttribute(JSONObject jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        Iterator keys = jsonAttribute.keys();
        ArrayList<SCIMAttribute> complexAttrs = new ArrayList<SCIMAttribute>(jsonAttribute.length());
        while (keys.hasNext()) {
            SCIMAttribute childAttr;
            Object o;
            String key = (String)keys.next();
            AttributeDescriptor subAttribute = attributeDescriptor.getSubAttribute(key);
            if (subAttribute == null) continue;
            if (subAttribute.isMultiValued()) {
                o = jsonAttribute.getJSONArray(key);
                childAttr = this.createMutiValuedAttribute((JSONArray)o, subAttribute);
            } else {
                o = jsonAttribute.get(key);
                childAttr = this.createSimpleAttribute(o, subAttribute);
            }
            complexAttrs.add(childAttr);
        }
        return SCIMAttributeValue.createComplexValue(complexAttrs);
    }

    protected SCIMAttribute create(AttributeDescriptor descriptor, Object jsonAttribute) throws JSONException, InvalidResourceException {
        if (descriptor.isMultiValued()) {
            JSONArray jsonArray;
            if (jsonAttribute instanceof JSONArray) {
                jsonArray = (JSONArray)jsonAttribute;
            } else {
                String[] s = new String[]{jsonAttribute.toString()};
                jsonArray = new JSONArray((Object)s);
            }
            return this.createMutiValuedAttribute(jsonArray, descriptor);
        }
        if (descriptor.getDataType() == AttributeDescriptor.DataType.COMPLEX) {
            if (!(jsonAttribute instanceof JSONObject)) {
                throw new InvalidResourceException("JSON object expected for multi-valued attribute '" + descriptor.getName() + "'");
            }
            return SCIMAttribute.create(descriptor, this.createComplexAttribute((JSONObject)jsonAttribute, descriptor));
        }
        return this.createSimpleAttribute(jsonAttribute, descriptor);
    }

    static final JSONObject makeCaseInsensitive(JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        Iterator keys = jsonObject.keys();
        HashMap<String, Object> lowerCaseMap = new HashMap<String, Object>(jsonObject.length());
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String lowerCaseKey = StaticUtils.toLowerCase(key);
            lowerCaseMap.put(lowerCaseKey, jsonObject.get(key));
        }
        return new JSONObject(lowerCaseMap);
    }
}

