/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import javax.xml.bind.DatatypeConverter;

public class OAuthToken {
    private final Type type;
    private final String tokenValue;
    private final byte[] rawTokenBytes;

    public OAuthToken(String tokenValue) {
        this(Type.Bearer, tokenValue);
    }

    public OAuthToken(Type type, String tokenValue) {
        this.type = type;
        this.tokenValue = tokenValue;
        this.rawTokenBytes = DatatypeConverter.parseBase64Binary((String)tokenValue);
    }

    public Type getType() {
        return this.type;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public byte[] getRawTokenBytes() {
        return this.rawTokenBytes;
    }

    public String getFormattedValue() {
        return this.getType().name() + " " + this.getTokenValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OAuth,
        Bearer;

    }
}

