/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMQueryAttributes {
    private final boolean allAttributesRequested;
    private final Map<AttributeDescriptor, Set<AttributeDescriptor>> descriptors;

    public SCIMQueryAttributes(ResourceDescriptor resourceDescriptor, String attributes) throws InvalidResourceException {
        this.descriptors = new HashMap<AttributeDescriptor, Set<AttributeDescriptor>>();
        if (attributes == null) {
            this.allAttributesRequested = true;
        } else {
            AttributeDescriptor meta;
            AttributeDescriptor id;
            String[] paths;
            this.allAttributesRequested = false;
            if (!attributes.isEmpty() && (paths = attributes.split(",")).length > 0) {
                for (String a : paths) {
                    AttributePath path = AttributePath.parse(a, resourceDescriptor.getSchema());
                    AttributeDescriptor attributeDescriptor = resourceDescriptor.getAttribute(path.getAttributeSchema(), path.getAttributeName());
                    Set<AttributeDescriptor> subAttributes = this.descriptors.get(attributeDescriptor);
                    if (subAttributes == null) {
                        subAttributes = new HashSet<AttributeDescriptor>();
                        if (path.getSubAttributeName() != null) {
                            subAttributes.add(attributeDescriptor.getSubAttribute(path.getSubAttributeName()));
                        }
                        this.descriptors.put(attributeDescriptor, subAttributes);
                        continue;
                    }
                    if (subAttributes.isEmpty()) continue;
                    if (path.getSubAttributeName() != null) {
                        subAttributes.add(attributeDescriptor.getSubAttribute(path.getSubAttributeName()));
                        continue;
                    }
                    subAttributes.clear();
                }
            }
            if (!this.descriptors.containsKey(id = resourceDescriptor.getAttribute("urn:scim:schemas:core:1.0", "id"))) {
                this.descriptors.put(id, new HashSet());
            }
            if (!this.descriptors.containsKey(meta = resourceDescriptor.getAttribute("urn:scim:schemas:core:1.0", "meta"))) {
                this.descriptors.put(meta, new HashSet());
            }
        }
    }

    public SCIMQueryAttributes(Map<AttributeDescriptor, Set<AttributeDescriptor>> descriptors) {
        this.allAttributesRequested = descriptors == null;
        this.descriptors = descriptors;
    }

    public boolean allAttributesRequested() {
        return this.allAttributesRequested;
    }

    public boolean isAttributeRequested(AttributeDescriptor attributeDescriptor) {
        return this.allAttributesRequested() || this.descriptors.containsKey(attributeDescriptor);
    }

    public Map<AttributeDescriptor, Set<AttributeDescriptor>> getDescriptors() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    public SCIMObject pareObject(SCIMObject scimObject) {
        if (this.allAttributesRequested()) {
            return scimObject;
        }
        SCIMObject paredObject = new SCIMObject();
        for (Map.Entry<AttributeDescriptor, Set<AttributeDescriptor>> entry : this.descriptors.entrySet()) {
            SCIMAttribute paredAttribute;
            AttributeDescriptor attributeDescriptor = entry.getKey();
            SCIMAttribute a = scimObject.getAttribute(attributeDescriptor.getSchema(), attributeDescriptor.getName());
            if (a == null || (paredAttribute = this.pareAttribute(a)) == null) continue;
            paredObject.addAttribute(paredAttribute);
        }
        return paredObject;
    }

    public SCIMAttribute pareAttribute(SCIMAttribute attribute) {
        AttributeDescriptor descriptor = attribute.getAttributeDescriptor();
        if (this.allAttributesRequested() || descriptor.getSubAttributes() == null) {
            return attribute;
        }
        Set<AttributeDescriptor> subDescriptors = this.descriptors.get(descriptor);
        if (subDescriptors == null) {
            return null;
        }
        if (subDescriptors.isEmpty()) {
            return attribute;
        }
        if (attribute.getAttributeDescriptor().isMultiValued()) {
            ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>();
            for (SCIMAttributeValue v : attribute.getValues()) {
                ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>();
                for (AttributeDescriptor d : subDescriptors) {
                    SCIMAttribute subAttribute = v.getAttribute(d.getName());
                    if (subAttribute == null) continue;
                    subAttributes.add(subAttribute);
                }
                values.add(SCIMAttributeValue.createComplexValue(subAttributes));
            }
            return SCIMAttribute.create(descriptor, values.toArray(new SCIMAttributeValue[values.size()]));
        }
        ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>();
        for (AttributeDescriptor d : subDescriptors) {
            SCIMAttribute subAttribute = attribute.getValue().getAttribute(d.getName());
            if (subAttribute == null) continue;
            subAttributes.add(subAttribute);
        }
        return SCIMAttribute.create(descriptor, SCIMAttributeValue.createComplexValue(subAttributes));
    }

    public SCIMQueryAttributes merge(SCIMQueryAttributes that) throws InvalidResourceException {
        if (this.allAttributesRequested || that.allAttributesRequested) {
            return new SCIMQueryAttributes(null);
        }
        HashMap<AttributeDescriptor, Set<AttributeDescriptor>> merged = new HashMap<AttributeDescriptor, Set<AttributeDescriptor>>(this.descriptors);
        for (Map.Entry<AttributeDescriptor, Set<AttributeDescriptor>> e : that.descriptors.entrySet()) {
            AttributeDescriptor attributeDescriptor = e.getKey();
            Set<AttributeDescriptor> thatSet = e.getValue();
            Set thisSet = (Set)merged.get(attributeDescriptor);
            if (thisSet == null) {
                merged.put(attributeDescriptor, thatSet);
                continue;
            }
            if (thisSet.isEmpty()) continue;
            if (thatSet.isEmpty()) {
                thisSet.clear();
                continue;
            }
            thisSet.addAll(thatSet);
        }
        return new SCIMQueryAttributes(merged);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SCIMQueryAttributes");
        sb.append("{allAttributesRequested=").append(this.allAttributesRequested);
        sb.append(", descriptors=").append(this.descriptors);
        sb.append('}');
        return sb.toString();
    }
}

