/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkEndpoint;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.BulkResponse;
import com.unboundid.scim.sdk.HttpBasicAuthSecurityHandler;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.OAuthSecurityHandler;
import com.unboundid.scim.sdk.OAuthToken;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.ClientHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMService {
    private final RestClient client;
    private final URI baseURL;
    private MediaType acceptType = MediaType.APPLICATION_JSON_TYPE;
    private MediaType contentType = MediaType.APPLICATION_JSON_TYPE;
    private final boolean[] overrides = new boolean[3];
    private String userAgent;

    public SCIMService(URI baseUrl, ClientConfig clientConfig) {
        this.baseURL = baseUrl;
        this.client = new RestClient(clientConfig);
    }

    public SCIMService(URI baseUrl) {
        this(baseUrl, new ClientConfig());
    }

    public SCIMService(URI baseUrl, OAuthToken oAuthToken) {
        this(baseUrl, new ClientConfig().handlers(new ClientHandler[]{new OAuthSecurityHandler(oAuthToken)}));
    }

    public SCIMService(URI baseUrl, String username, String password) {
        this(baseUrl, new ClientConfig().handlers(new ClientHandler[]{new HttpBasicAuthSecurityHandler(username, password)}));
    }

    public <R extends BaseResource> SCIMEndpoint<R> getEndpoint(ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) {
        return new SCIMEndpoint<R>(this, this.client, resourceDescriptor, resourceFactory);
    }

    public SCIMEndpoint<UserResource> getUserEndpoint() {
        return new SCIMEndpoint<UserResource>(this, this.client, CoreSchema.USER_DESCRIPTOR, UserResource.USER_RESOURCE_FACTORY);
    }

    public SCIMEndpoint<GroupResource> getGroupEndpoint() {
        return new SCIMEndpoint<GroupResource>(this, this.client, CoreSchema.GROUP_DESCRIPTOR, GroupResource.GROUP_RESOURCE_FACTORY);
    }

    public SCIMEndpoint<ResourceDescriptor> getResourceSchemaEndpoint() {
        return new SCIMEndpoint<ResourceDescriptor>(this, this.client, CoreSchema.RESOURCE_SCHEMA_DESCRIPTOR, ResourceDescriptor.RESOURCE_DESCRIPTOR_FACTORY);
    }

    public ResourceDescriptor getResourceDescriptor(String resourceName, String schema) throws SCIMException {
        Resources<ResourceDescriptor> resources;
        SCIMEndpoint<ResourceDescriptor> endpoint = this.getResourceSchemaEndpoint();
        String filter = "name eq \"" + resourceName + "\"";
        if (schema != null) {
            filter = filter + " and schema eq \"" + schema + "\"";
        }
        if ((resources = endpoint.query(filter)).getTotalResults() == 0L) {
            return null;
        }
        if (resources.getTotalResults() > 1L) {
            throw new InvalidResourceException("The service provider returned multiple resource descriptors with resource name '" + resourceName);
        }
        ResourceDescriptor descriptor = resources.iterator().next();
        if ("urn:unboundid:schemas:scim:ldap:1.0".equalsIgnoreCase(descriptor.getSchema())) {
            descriptor.setStrictMode(false);
        }
        return descriptor;
    }

    public ServiceProviderConfig getServiceProviderConfig() throws SCIMException {
        SCIMEndpoint<ServiceProviderConfig> endpoint = this.getEndpoint(CoreSchema.SERVICE_PROVIDER_CONFIG_SCHEMA_DESCRIPTOR, ServiceProviderConfig.SERVICE_PROVIDER_CONFIG_RESOURCE_FACTORY);
        return endpoint.get(null);
    }

    public BulkResponse processBulkRequest(List<BulkOperation> operations) throws SCIMException {
        return this.processBulkRequest(operations, -1);
    }

    public BulkResponse processBulkRequest(List<BulkOperation> operations, int failOnErrors) throws SCIMException {
        BulkEndpoint request = new BulkEndpoint(this, this.client);
        return request.processRequest(operations, failOnErrors);
    }

    public URI getBaseURL() {
        return this.baseURL;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    public MediaType getAcceptType() {
        return this.acceptType;
    }

    public void setAcceptType(MediaType acceptType) {
        this.acceptType = acceptType;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isOverrideDelete() {
        return this.overrides[2];
    }

    public void setOverrideDelete(boolean overrideDelete) {
        this.overrides[2] = overrideDelete;
    }

    public boolean isOverridePatch() {
        return this.overrides[1];
    }

    public void setOverridePatch(boolean overridePatch) {
        this.overrides[1] = overridePatch;
    }

    public boolean isOverridePut() {
        return this.overrides[0];
    }

    public void setOverridePut(boolean overridePut) {
        this.overrides[0] = overridePut;
    }
}

