/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;

public class SimpleValue {
    private static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private final Object value;

    public SimpleValue(String stringValue) {
        this.value = stringValue;
    }

    public SimpleValue(Boolean booleanValue) {
        this.value = booleanValue.toString();
    }

    public SimpleValue(Date dateValue) {
        GregorianCalendar calendar = new GregorianCalendar(utcTimeZone);
        calendar.setTime(dateValue);
        this.value = DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public SimpleValue(byte[] bytes) {
        this.value = bytes;
    }

    public String getStringValue() {
        if (this.value instanceof byte[]) {
            return DatatypeConverter.printBase64Binary((byte[])((byte[])this.value));
        }
        return (String)this.value;
    }

    public Boolean getBooleanValue() {
        return Boolean.valueOf((String)this.value);
    }

    public Double getDoubleValue() {
        return Double.valueOf((String)this.value);
    }

    public Long getLongValue() {
        return Long.valueOf((String)this.value);
    }

    public Date getDateValue() {
        Calendar calendar = DatatypeConverter.parseDateTime((String)((String)this.value));
        calendar.setTimeZone(utcTimeZone);
        return calendar.getTime();
    }

    public byte[] getBinaryValue() {
        return (byte[])this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleValue");
        sb.append("{value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleValue that = (SimpleValue)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

