/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.AttributePath;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.GetResourceRequest;
import com.unboundid.scim.sdk.GetResourcesRequest;
import com.unboundid.scim.sdk.OAuthToken;
import com.unboundid.scim.sdk.OAuthTokenHandler;
import com.unboundid.scim.sdk.OAuthTokenStatus;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.PatchResourceRequest;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilter;
import com.unboundid.scim.sdk.SCIMQueryAttributes;
import com.unboundid.scim.sdk.SCIMRequest;
import com.unboundid.scim.sdk.SCIMResponse;
import com.unboundid.scim.sdk.SortParameters;
import com.unboundid.scim.sdk.UnauthorizedException;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.ResourceStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.DatatypeConverter;
import org.apache.wink.common.AbstractDynamicResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSCIMResource
extends AbstractDynamicResource {
    private final ResourceDescriptor resourceDescriptor;
    private final ResourceStats resourceStats;
    private final SCIMBackend backend;
    private final OAuthTokenHandler tokenHandler;

    public AbstractSCIMResource(String path, ResourceDescriptor resourceDescriptor, ResourceStats resourceStats, SCIMBackend backend, OAuthTokenHandler tokenHandler) {
        this.resourceDescriptor = resourceDescriptor;
        this.backend = backend;
        this.tokenHandler = tokenHandler;
        this.resourceStats = resourceStats;
        super.setPath(path);
    }

    Response getUser(RequestContext requestContext, String userID) {
        Response.ResponseBuilder responseBuilder;
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(this.resourceDescriptor, attributes);
            GetResourceRequest getResourceRequest = new GetResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, queryAttributes);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, getResourceRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("get-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                getResourceRequest = new GetResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, queryAttributes);
            }
            BaseResource resource = this.backend.getResource(getResourceRequest);
            responseBuilder = Response.status((Response.Status)Response.Status.OK);
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resource);
            URI location = resource.getMeta().getLocation();
            if (location != null) {
                responseBuilder.location(location);
            }
            this.resourceStats.incrementStat("get-successful");
        }
        catch (SCIMException e) {
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("get-" + e.getStatusCode());
        }
        if (requestContext.getOrigin() != null) {
            responseBuilder.header("Access-Control-Allow-Origin", (Object)requestContext.getOrigin());
        }
        responseBuilder.header("Access-Control-Allow-Credentials", (Object)Boolean.TRUE.toString());
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.resourceStats.incrementStat("get-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.resourceStats.incrementStat("get-response-xml");
        }
        return responseBuilder.build();
    }

    protected Response getUsers(RequestContext requestContext, String filterString, String baseID, String searchScope, String sortBy, String sortOrder, String pageStartIndex, String pageSize) {
        Response.ResponseBuilder responseBuilder;
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(this.resourceDescriptor, attributes);
            SCIMFilter filter = filterString != null && !filterString.isEmpty() ? SCIMFilter.parse(filterString, this.resourceDescriptor.getSchema()) : null;
            SortParameters sortParameters = sortBy != null && !sortBy.isEmpty() ? new SortParameters(AttributePath.parse(sortBy, this.resourceDescriptor.getSchema()), sortOrder) : null;
            long startIndex = -1L;
            int count = -1;
            if (pageStartIndex != null && !pageStartIndex.isEmpty()) {
                try {
                    startIndex = Long.parseLong(pageStartIndex);
                }
                catch (NumberFormatException e) {
                    Debug.debugException(e);
                    throw SCIMException.createException(400, "The pagination startIndex value '" + pageStartIndex + "' is not parsable");
                }
                if (startIndex <= 0L) {
                    throw SCIMException.createException(400, "The pagination startIndex value '" + pageStartIndex + "' is invalid because it is not greater than zero");
                }
            }
            if (pageSize != null && !pageSize.isEmpty()) {
                try {
                    count = Integer.parseInt(pageSize);
                }
                catch (NumberFormatException e) {
                    Debug.debugException(e);
                    throw SCIMException.createException(400, "The pagination count value '" + pageSize + "' is not parsable");
                }
                if (count <= 0) {
                    throw SCIMException.createException(400, "The pagination count value '" + pageSize + "' is invalid because it is not greater than zero");
                }
            }
            PageParameters pageParameters = startIndex >= 0L && count >= 0 ? new PageParameters(startIndex, count) : (startIndex >= 0L ? new PageParameters(startIndex, 0) : (count >= 0 ? new PageParameters(1L, count) : null));
            GetResourcesRequest getResourcesRequest = new GetResourcesRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, filter, baseID, searchScope, sortParameters, pageParameters, queryAttributes);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, getResourcesRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("query-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                getResourcesRequest = new GetResourcesRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, filter, baseID, searchScope, sortParameters, pageParameters, queryAttributes);
            }
            Resources resources = this.backend.getResources(getResourcesRequest);
            responseBuilder = Response.status((Response.Status)Response.Status.OK);
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resources);
            this.resourceStats.incrementStat("query-successful");
        }
        catch (SCIMException e) {
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("query-" + e.getStatusCode());
        }
        if (requestContext.getOrigin() != null) {
            responseBuilder.header("Access-Control-Allow-Origin", (Object)requestContext.getOrigin());
        }
        responseBuilder.header("Access-Control-Allow-Credentials", (Object)Boolean.TRUE.toString());
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.resourceStats.incrementStat("query-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.resourceStats.incrementStat("query-response-xml");
        }
        return responseBuilder.build();
    }

    Response postUser(RequestContext requestContext, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        Unmarshaller unmarshaller;
        if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            unmarshaller = new JsonUnmarshaller();
            this.resourceStats.incrementStat("post-content-json");
        } else {
            unmarshaller = new XmlUnmarshaller();
            this.resourceStats.incrementStat("post-content-xml");
        }
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            BaseResource postedResource = unmarshaller.unmarshal(inputStream, this.resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
            String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(this.resourceDescriptor, attributes);
            PostResourceRequest postResourceRequest = new PostResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, postedResource.getScimObject(), queryAttributes);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, postResourceRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("post-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                postResourceRequest = new PostResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, postedResource.getScimObject(), queryAttributes);
            }
            BaseResource resource = this.backend.postResource(postResourceRequest);
            responseBuilder = Response.status((Response.Status)Response.Status.CREATED);
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), resource);
            responseBuilder.location(resource.getMeta().getLocation());
            this.resourceStats.incrementStat("post-successful");
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("post-" + e.getStatusCode());
        }
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.resourceStats.incrementStat("post-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.resourceStats.incrementStat("post-response-xml");
        }
        return responseBuilder.build();
    }

    Response putUser(RequestContext requestContext, String userID, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        Unmarshaller unmarshaller;
        if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            unmarshaller = new JsonUnmarshaller();
            this.resourceStats.incrementStat("put-content-json");
        } else {
            unmarshaller = new XmlUnmarshaller();
            this.resourceStats.incrementStat("put-content-xml");
        }
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            BaseResource puttedResource = unmarshaller.unmarshal(inputStream, this.resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
            String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(this.resourceDescriptor, attributes);
            PutResourceRequest putResourceRequest = new PutResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, puttedResource.getScimObject(), queryAttributes);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, putResourceRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("put-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                putResourceRequest = new PutResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, puttedResource.getScimObject(), queryAttributes);
            }
            BaseResource scimResponse = this.backend.putResource(putResourceRequest);
            responseBuilder = Response.status((Response.Status)Response.Status.OK);
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), scimResponse);
            responseBuilder.location(scimResponse.getMeta().getLocation());
            this.resourceStats.incrementStat("put-successful");
        }
        catch (SCIMException e) {
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("put-" + e.getStatusCode());
        }
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.resourceStats.incrementStat("put-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.resourceStats.incrementStat("put-response-xml");
        }
        return responseBuilder.build();
    }

    Response patchUser(RequestContext requestContext, String userID, InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        Unmarshaller unmarshaller;
        if (requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            unmarshaller = new JsonUnmarshaller();
            this.resourceStats.incrementStat("patch-content-json");
        } else {
            unmarshaller = new XmlUnmarshaller();
            this.resourceStats.incrementStat("patch-content-xml");
        }
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            BaseResource patchedResource = unmarshaller.unmarshal(inputStream, this.resourceDescriptor, BaseResource.BASE_RESOURCE_FACTORY);
            String attributes = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"attributes");
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(this.resourceDescriptor, attributes);
            PatchResourceRequest patchResourceRequest = new PatchResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, patchedResource.getScimObject(), queryAttributes);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, patchResourceRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("patch-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                patchResourceRequest = new PatchResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID, patchedResource.getScimObject(), queryAttributes);
            }
            BaseResource scimResponse = this.backend.patchResource(patchResourceRequest);
            if (!queryAttributes.allAttributesRequested()) {
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
                this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), scimResponse);
            } else {
                responseBuilder = Response.status((Response.Status)Response.Status.NO_CONTENT);
            }
            this.resourceStats.incrementStat("patch-successful");
        }
        catch (SCIMException e) {
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("patch-" + e.getStatusCode());
        }
        if (requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            this.resourceStats.incrementStat("patch-response-json");
        } else if (requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            this.resourceStats.incrementStat("patch-response-xml");
        }
        return responseBuilder.build();
    }

    Response deleteUser(RequestContext requestContext, String userID) {
        Response.ResponseBuilder responseBuilder;
        try {
            String authID = requestContext.getAuthID();
            if (authID == null && this.tokenHandler == null) {
                throw new UnauthorizedException("Invalid credentials");
            }
            DeleteResourceRequest deleteResourceRequest = new DeleteResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID);
            if (authID == null) {
                AtomicReference<String> authIDRef = new AtomicReference<String>();
                Response response = AbstractSCIMResource.validateOAuthToken(requestContext, deleteResourceRequest, authIDRef, this.tokenHandler);
                if (response != null) {
                    this.resourceStats.incrementStat("delete-" + response.getStatus());
                    return response;
                }
                authID = authIDRef.get();
                deleteResourceRequest = new DeleteResourceRequest(requestContext.getUriInfo().getBaseUri(), authID, this.resourceDescriptor, userID);
            }
            this.backend.deleteResource(deleteResourceRequest);
            responseBuilder = Response.status((Response.Status)Response.Status.OK);
            this.resourceStats.incrementStat("delete-successful");
        }
        catch (SCIMException e) {
            responseBuilder = Response.status((int)e.getStatusCode());
            this.setResponseEntity(responseBuilder, requestContext.getProduceMediaType(), e);
            this.resourceStats.incrementStat("delete-" + e.getStatusCode());
        }
        return responseBuilder.build();
    }

    private void setResponseEntity(Response.ResponseBuilder builder, MediaType mediaType, final SCIMResponse scimResponse) {
        builder.type(mediaType);
        final Marshaller marshaller = mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonMarshaller() : new XmlMarshaller();
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    scimResponse.marshal(marshaller, outputStream);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
        };
        builder.entity((Object)output);
    }

    static Response validateOAuthToken(RequestContext context, SCIMRequest request, AtomicReference<String> authIDRef, OAuthTokenHandler tokenHandlerImpl) {
        HttpHeaders headers = context.getHeaders();
        List headerList = headers.getRequestHeader("Authorization");
        if (headerList == null || headerList.isEmpty()) {
            Response.ResponseBuilder builder = Response.status((int)401);
            builder.header("WWW-Authenticate", (Object)"Bearer realm=SCIM");
            return builder.build();
        }
        if (headerList.size() > 1) {
            return AbstractSCIMResource.invalidRequest("The Authorization header has too many values");
        }
        String header = (String)headerList.get(0);
        String[] authorization = header.split(" ");
        if (authorization.length == 2 && authorization[0].equalsIgnoreCase("Bearer") && authorization[1].length() > 0) {
            try {
                byte[] rawToken = DatatypeConverter.parseBase64Binary((String)authorization[1]);
                if (rawToken == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException e) {
                return AbstractSCIMResource.invalidRequest("The access token cannot be base64-decoded");
            }
            try {
                OAuthToken token = tokenHandlerImpl.decodeOAuthToken(authorization[1]);
                if (token == null) {
                    return AbstractSCIMResource.invalidRequest("Could not decode the access token");
                }
                if (!tokenHandlerImpl.isTokenAuthentic(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is not authentic");
                }
                if (!tokenHandlerImpl.isTokenForThisServer(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is not intended for this server");
                }
                if (tokenHandlerImpl.isTokenExpired(token)) {
                    return AbstractSCIMResource.invalidToken("The access token is expired");
                }
                OAuthTokenStatus status = tokenHandlerImpl.validateToken(token, request);
                if (status.getErrorCode().equals((Object)OAuthTokenStatus.ErrorCode.INVALID_TOKEN)) {
                    String errorDescription = status.getErrorDescription();
                    return AbstractSCIMResource.invalidToken(errorDescription);
                }
                if (status.getErrorCode().equals((Object)OAuthTokenStatus.ErrorCode.INSUFFICIENT_SCOPE)) {
                    String errorDescription = status.getErrorDescription();
                    String scope = status.getScope();
                    return AbstractSCIMResource.insufficientScope(scope, errorDescription);
                }
                String authID = tokenHandlerImpl.getAuthzDN(token);
                if (authID == null) {
                    return AbstractSCIMResource.invalidToken("The access token did not contain an authorization DN");
                }
                authIDRef.set(authID);
                return null;
            }
            catch (Throwable t) {
                Debug.debugException(t);
                return AbstractSCIMResource.invalidRequest(t.getMessage());
            }
        }
        if (authorization.length == 2 && authorization[0].equalsIgnoreCase("Basic") && authorization[1].length() > 0) {
            Response.ResponseBuilder builder = Response.status((int)401);
            builder.header("WWW-Authenticate", (Object)"Basic realm=SCIM");
            return builder.build();
        }
        return AbstractSCIMResource.invalidRequest("The Authorization header was malformed");
    }

    private static Response invalidRequest(String errorDescription) {
        Response.ResponseBuilder builder = Response.status((int)400);
        builder.header("WWW-Authenticate", (Object)"Bearer realm=SCIM");
        builder.header("WWW-Authenticate", (Object)"error=\"invalid_request\"");
        if (errorDescription != null && !errorDescription.isEmpty()) {
            builder.header("WWW-Authenticate", (Object)("error_description=\"" + errorDescription + "\""));
        }
        return builder.build();
    }

    private static Response invalidToken(String errorDescription) {
        Response.ResponseBuilder builder = Response.status((int)401);
        builder.header("WWW-Authenticate", (Object)"Bearer realm=SCIM");
        builder.header("WWW-Authenticate", (Object)"error=\"invalid_token\"");
        if (errorDescription != null && !errorDescription.isEmpty()) {
            builder.header("WWW-Authenticate", (Object)("error_description=\"" + errorDescription + "\""));
        }
        return builder.build();
    }

    private static Response insufficientScope(String scope, String errorDescription) {
        Response.ResponseBuilder builder = Response.status((int)403);
        builder.header("WWW-Authenticate", (Object)"Bearer realm=SCIM");
        builder.header("WWW-Authenticate", (Object)"error=\"insufficient_scope\"");
        if (errorDescription != null && !errorDescription.isEmpty()) {
            builder.header("WWW-Authenticate", (Object)("error_description=\"" + errorDescription + "\""));
        }
        if (scope != null && !scope.isEmpty()) {
            builder.header("WWW-Authenticate", (Object)("scope=\"" + scope + "\""));
        }
        return builder.build();
    }
}

