/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.wink.AbstractStaticResource;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMApplication;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="ServiceProviderConfigs")
public class ServiceProviderConfigResource
extends AbstractStaticResource {
    private final SCIMApplication application;
    private final ResourceStats resourceStats;

    public ServiceProviderConfigResource(SCIMApplication application, ResourceStats resourceStats) {
        this.application = application;
        this.resourceStats = resourceStats;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doJsonGet() {
        ServiceProviderConfig config = this.application.getServiceProviderConfig();
        Response.ResponseBuilder builder = Response.ok();
        this.setResponseEntity(builder, MediaType.APPLICATION_JSON_TYPE, config);
        this.resourceStats.incrementStat("get-response-json");
        this.resourceStats.incrementStat("get-successful");
        return builder.build();
    }

    @GET
    @Produces(value={"application/xml"})
    public Response doXmlGet() {
        ServiceProviderConfig config = this.application.getServiceProviderConfig();
        Response.ResponseBuilder builder = Response.ok();
        this.setResponseEntity(builder, MediaType.APPLICATION_XML_TYPE, config);
        this.resourceStats.incrementStat("get-response-xml");
        this.resourceStats.incrementStat("get-successful");
        return builder.build();
    }
}

